<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Loading_ctrl extends user_index {
 
	
	public function __construct(){ 
		parent::__construct();
		$data = array();
		$this->load->model('admin_model');	
		$this->load->model('loading_model');	
	} 
	
	/*----------------- load loading vehicle  entry list page -----------------*/
	public function loading_list(){	
		$data['sdata'] 				= array();
		$data['subview'] 			= 'loading/loading_list';
		$data['active_cls'] 		= 'loadaa_lcs';		
		$data['sdata']['lul_list'] 			= $this->loading_model->get_loading_list('Loading');		
		$this->load->view('common/sidepanel',$data);
	}

	/*----------------- load loading vehicle  entry details page -----------------*/
	public function loading_details_list($lul_id){	
		$data['sdata'] 				= array();
		$data['subview'] 			= 'loading/loading_details_list';
		$data['active_cls'] 		= 'loadaa_lcs';		
		$data['sdata']['lul_data'] 			= $this->loading_model->get_loading_list('Loading',$lul_id);
		$data['sdata']['luml_data'] 		= $this->loading_model->get_loading_or_unloading_meterial_list($lul_id);		
		$this->load->view('common/sidepanel',$data);
	}
	

	/*----------------- load add loading vehicle  entry details page ----------------*/
	public function add_loading_vehicle_entry_details($lul_id=''){
		if($this->user['panel_type']=='1' && in_array("1", $this->u_roles)){	
			$data['sdata'] 						= array();
			$data['subview'] 					= 'loading/add_l_vehicle_entry_details';
			$data['active_cls'] 				= 'loadaa_lcs';	
			$data['sdata']['cl_list'] 			= $this->admin_model->get_result_array('customer_list');				
			$data['sdata']['tl_list'] 			= $this->admin_model->get_result_array('transporter_list');				
			$data['sdata']['com_list'] 			= $this->admin_model->get_result_array('commodity_list');	
			$data['sdata']['lul_count'] 		= $this->admin_model->get_counts('loading_unloading_list');	
			$data['sdata']['lul_id'] 			= $lul_id;	
			if($lul_id!=''){
				$data['sdata']['view_type'] 	= "Edit";
				$data['sdata']['lul_data'] = $this->admin_model->get_result_array('loading_unloading_list','lul_id',$lul_id);	
			}else{
				$data['sdata']['view_type'] 	= "Add";
			}
			$this->load->view('common/sidepanel',$data);
		}else{
			redirect('login_ctrl/logout');
		}
	}
	
	
	/*----------------- add loading vehicle  entry  details and edit loading vehicle  entry  details -----------------*/
	public function insert_loaading_details($lul_id= false){
		if(($this->user['panel_type']!='1') && (!in_array("1", $this->u_roles))){
			redirect('login_ctrl/logout');
		}		
		$this->form_validation->set_rules('lul_date', 'Date', 'trim|required');
		$this->form_validation->set_rules('lul_token_no', 'Token', 'trim|required');
		$this->form_validation->set_rules('lul_cl_id', 'Customer', 'trim|required');
		$this->form_validation->set_rules('lul_com_id', 'Commodity', 'trim|required');
		$this->form_validation->set_rules('lul_truck_no', 'Truck No', 'trim|required');
		$this->form_validation->set_rules('lul_tl_id', 'Transporter', 'trim|required');
		$this->form_validation->set_rules('lul_driver_name', 'Driver name', 'trim|required');
		$this->form_validation->set_rules('lul_driver_ph_no', 'Driver phone no', 'trim|required');
		$this->form_validation->set_rules('lul_lic', 'Driver Lic', 'trim|required');
		$this->form_validation->set_rules('lul_time_in', 'Time in', 'trim|required');
		$this->form_validation->set_rules('lul_trailer_no', 'Trailer no', 'trim|required');
		$this->form_validation->set_rules('lul_destination', 'Destination', 'trim|required');
		
		if ($this->form_validation->run() === FALSE) {
			$e_msg = '';
			$e_msg .= form_error('lul_date');  				$e_msg .= form_error('lul_token_no');  			
			$e_msg .= form_error('lul_cl_id');   			$e_msg .= form_error('lul_com_id'); 
			$e_msg .= form_error('lul_truck_no');   		$e_msg .= form_error('lul_tl_id');   
			$e_msg .= form_error('lul_driver_name');   		$e_msg .= form_error('lul_driver_ph_no');   
			$e_msg .= form_error('lul_lic');   			    $e_msg .= form_error('lul_time_in');
			$e_msg .= form_error('lul_trailer_no'); 		$e_msg .= form_error('lul_destination');  
			$this->session->set_flashdata('tos_error', $e_msg);
			redirect('loading_ctrl/add_loading_vehicle_entry_details');				
			
		}	
		$data['lul_details'] = array();
		foreach($_POST as $post_key=>$post_rows){
			$data['lul_details'][$post_key] 		= $this->input->post($post_key);
		}
		
		$data['lul_details']['lul_e_o_id'] 			= $this->user['i_user_id'];
		$data['lul_details']['lul_e_o_date_time'] 	= date("Y-m-d h:i a");
		$data['lul_details']['lul_type'] 			= "Loading";
		if($lul_id==false){				
			$add_cl 						= $this->admin_model->insert_item('loading_unloading_list',$data['lul_details']);	
			
			if($add_cl!=false){
				$this->session->set_flashdata('tos_success', 'Loading details added.');
				redirect('loading_ctrl/add_loading_vehicle_entry_details');
			}else {
				$this->session->set_flashdata('tos_error', 'Try again !...');
				redirect('loading_ctrl/add_loading_vehicle_entry_details');
			}			
		}else{
			$edit_cl = $this->admin_model->update_data('loading_unloading_list','lul_id',$lul_id,$data['lul_details']);
			if($edit_cl=='1'){
				$this->session->set_flashdata('tos_success', 'Loading details updated');
				redirect('loading_ctrl/add_loading_vehicle_entry_details');
			}else {
				$this->session->set_flashdata('tos_warning', 'There is no changes!...');
				redirect('loading_ctrl/add_loading_vehicle_entry_details/'.$lul_id);
			}
		}		
	}

	
	

	
}
