<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Site_ctrl extends CI_Controller {
	public function __construct(){
		parent::__construct();
		$data = array();
		$this->load->model('public_model');

	}
	
	public function index(){
		$data1['active_cls'] 		= 'ho_cls';
		$data1['header_type'] 		= '0';
		$data2['dsl_list'] 			= $this->public_model->get_result_array_with_one_where('driving_school_list','dsl_status','1');
		$dsl_l_res = $this->get_locations();
		$this->load->view('header',$data1);	
		$this->load->view('index',$data2);	
		$this->load->view('footer');	
	}

	public function profile($dsl_data){
		$ex_dsl 					= explode('-',$dsl_data);
		$dsl_id 					= end($ex_dsl);
		$data1['active_cls'] 		= 'ho_cls';
		$data1['header_type'] 		= '1';
		$data2['dsl_data'] 			= $this->public_model->get_result_array('driving_school_list','','','dsl_id',$dsl_id);;
		$this->load->view('header',$data1);	
		$this->load->view('profile',$data2);	
		$this->load->view('footer');	
	}

	public function login(){
		$data1['active_cls'] 		= 'ho_cls';
		$data1['header_type'] 		= '1';
		$this->load->view('header',$data1);	
		$this->load->view('login');	
		$this->load->view('footer');	
	}
	
	public function register(){
		$data1['active_cls'] 		= 'ho_cls';
		$data1['header_type'] 		= '1';
		$this->load->view('header',$data1);	
		$this->load->view('register');	
		$this->load->view('footer');	
	}


	public function get_locations(){
		$dsl_list 			= $this->public_model->get_result_array_with_one_where('driving_school_list','dsl_status','1');
		$res = array();
		foreach($dsl_list  as $dsl_keys=>$dsl_rows){
			$resc['dsl_location'] 	= $dsl_rows['dsl_location'];
			$resc['dsl_pincode'] 	= $dsl_rows['dsl_pincode'];
			$res[] = $resc;
		}
		// var_dump($res);
		// If the json is correct, you can then write the file and load the view

		$fp = fopen('location_list.json', 'w');
		fwrite($fp, json_encode($res));
	}

	public function register_submit(){		
		$this->form_validation->set_rules('dsl_d_name', 'Driving school name', 'trim|required');
		$this->form_validation->set_rules('dsl_name', 'Name', 'trim|required');
		$this->form_validation->set_rules('dsl_gender', 'Gender', 'trim|required');
		$this->form_validation->set_rules('dsl_mobile', 'Contact Number', 'trim|required');
		
		if ($this->form_validation->run() === FALSE) {
			$e_msg = '';
			$e_msg .= form_error('dsl_d_name');  				$e_msg .= form_error('dsl_name');  			
			$e_msg .= form_error('dsl_gender');  		        $e_msg .= form_error('dsl_mobile'); 	
			$e_msg .= form_error('dsl_email'); 					$e_msg .= form_error('dsl_address');	
			$e_msg .= form_error('dsl_location'); 		 		$e_msg .= form_error('dsl_pincode');
			$this->session->set_flashdata('tos_error', $e_msg);
			redirect('register');
		}	
		$data['dsl_details'] = array();
		foreach($_POST as $post_key=>$post_rows){
			$data['dsl_details'][$post_key] 		= $this->input->post($post_key);
		}

		$data['l_dsl']['l_user'] 				= $this->input->post('dsl_email');
		$data['l_dsl']['l_user_name'] 			= $this->input->post('dsl_d_name');
		$data['l_dsl']['l_pwd'] 				= md5($this->input->post('dsl_mobile'));
		$data['l_dsl']['i_type'] 				= '1';


		$check_email		= $this->public_model->get_result_array('login','','','l_user',$data['dsl_details']['dsl_email']);		
		$c_size 			= sizeof($check_email);
		if($c_size=='0'){
			$add_dsl 						= $this->public_model->insert_item('driving_school_list',$data['dsl_details']);		
			$data['l_dsl']['i_user_id'] 	= $add_dsl;
			$add_login 						= $this->public_model->insert_item('login',$data['l_dsl']);
			if($add_login!=false){
				$this->session->set_flashdata('tos_success', 'Driving school details added.');
				redirect('register');
			}else {
				$this->session->set_flashdata('tos_error', 'Try again !...');
				redirect('register');
			}
		}else{
			$this->session->set_flashdata('tos_error', 'Email id already exist !...');
			redirect('register');
		}
			
	}

	public function submit_search(){		
		$data1['active_cls'] 		= 'ho_cls';
		$data1['header_type'] 		= '1';


		$dsl_pincode				= $this->input->post('dsl_pincode');
		$dsl_location				= $this->input->post('dsl_location');
		$data2['dsl_list'] 			= $this->public_model->get_search_result($dsl_pincode,$dsl_location);	
					
		$this->load->view('header',$data1);	
		$this->load->view('instructor_list',$data2);	
		$this->load->view('footer');				
	}
	 
	public function lessons(){
		$data1['active_cls'] 		= 'ho_cls';
		$data1['header_type'] 		= '1';
		$data2['ll_list'] 			= $this->public_model->get_result_array('lessons_list');
		$this->load->view('header',$data1);	
		$this->load->view('lessons',$data2);	
		$this->load->view('footer');	
	}

	public function contact(){
		$data1['active_cls'] 		= 'ho_cls';
		$data1['header_type'] 		= '1';
		$this->load->view('header',$data1);	
		$this->load->view('contact');	
		$this->load->view('footer');	
	}

	





	
	
}
