<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Cro_ctrl extends user_icd_index {
 
	
	public function __construct(){
		parent::__construct();   
		$data = array();
		$this->load->model('admin_model');
		$this->load->model('icd_model');		 
	}
	
	/*----------------- load container_selection_release_list page -----------------*/
	public function container_selection_release_list(){		
		$data['sdata'] 			= array();
		$data['subview'] 		= 'icd/cro/container_selection_release_list';		
		$data['active_cls'] 	= 'conedl_cls';	
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');			
		$data['sdata']['igedl_list'] 		= $this->icd_model->get_icd_igedl_details_list('','','','1','1','1','1','1','1','1','1','1','1','1','1','1','1');
		// echo $this->db->last_query();return;
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*----------------- load container_selection_release_form page -----------------*/
	public function container_selection_release_form($igedl_id){		
		$data['sdata'] 					= array();
		$data['subview'] 				= 'icd/cro/container_selection_release_form';		
		$data['active_cls'] 			= 'dash';			
		$data['url_list'] 				= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');			
					
		$data['sdata']['aginl_no'] 		= $this->admin_model->get_result_array('auto_generate_id_no_list','aginl_id','6');
		
		$data['sdata']['igedl_data'] 	= $this->icd_model->get_icd_igedl_details_list('',$igedl_id,'','1','1','1','1','1','1','1','1','1','1','1','1','1','1');		
		
		
		$data['sdata']['ivcl_list'] 	= $this->icd_model->get_icdl_ivcl_details_list('',$igedl_id,'','1','','0');
		// echo $this->db->last_query();return;
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*----------------- update_container_release_details -----------------*/
	public function update_container_release_details($igedl_id){	
		$aginl_t_no 		= $this->admin_model->get_result_array('auto_generate_id_no_list','aginl_id','6');

		
		// var_dump($this->input->post('igedl_cro_re_c_no'));return;
		$this->form_validation->set_rules('igetl_vat_amount', 'VAT Amount', 'trim|required');
		$this->form_validation->set_rules('igetl_invoice_date', 'Invoice Date', 'trim|required');
		$this->form_validation->set_rules('igetl_total_amount', 'Total Amount', 'trim|required');
		$this->form_validation->set_rules('igetl_sub_total', 'Inv Sub Total', 'trim|required');

		
		if ($this->form_validation->run() === FALSE) {
			$e_msg = ''; 			
			$e_msg .= form_error('igetl_vat_amount');   		
			$e_msg .= form_error('igetl_invoice_date');   		
			$e_msg .= form_error('igetl_total_amount');   		
			$e_msg .= form_error('igetl_sub_total');   		
			$this->session->set_flashdata('tos_error', $e_msg);
			redirect('icd/cro_ctrl/container_selection_release_list');	return;	
		}	
		
		$data['igetl']['igetl_vat_amount'] 		= $this->input->post('igetl_vat_amount');
		$data['igetl']['igetl_invoice_date'] 	= $this->input->post('igetl_invoice_date');	
		$data['igetl']['igetl_total_amount'] 	= $this->input->post('igetl_total_amount');
		$data['igetl']['igetl_sub_total'] 		= $this->input->post('igetl_sub_total');
		$data['igetl']['igetl_cro_id'] 			= $this->user['i_user_id'];
		$data['igetl']['igetl_cro_status'] 		= '1';
		$data['igetl']['igetl_cro_date'] 		= date("Y-m-d");

		$icdl_id 								= $this->input->post('icdl_id');	
		$igetl_id 								= $this->input->post('igetl_id');	
		$igetl_token_type 						= $this->input->post('igetl_token_type');	
		// $igetl_token_no 						= $this->input->post('igetl_token_no');	
		$igetl_expiry_date 						= $this->input->post('igetl_expiry_date');	
		
		foreach($igetl_id as $igetl_key=>$igetl_row){	
			$tkn_no 								=  $aginl_t_no['aginl_val']+$igetl_key;
			$data['igetl']['igetl_igedl_id'] 		=  $igedl_id;
			$data['igetl']['igetl_token_type'] 		=  $igetl_token_type[$igetl_key];
			$data['igetl']['igetl_token_no'] 		=  'TKN-000'.$tkn_no;
			$data['igetl']['igetl_expiry_date'] 	=  $igetl_expiry_date[$igetl_key];
			$add_igetl 								=  $this->admin_model->insert_item('icd_gate_entry_token_list',$data['igetl']);		
			
				
			$itncl_re = $this->admin_model->get_result_array_with_two_where('icd_token_no_container_list','itncl_igetl_id',$igedl_id,'itncl_icdl_id',$icdl_id);
			if(isset($itncl_re) && sizeOf($itncl_re)==0){
				$data['itncl']['itncl_igetl_id'] 	=  $add_igetl;
				$data['itncl']['itncl_icdl_id'] 	=  $icdl_id;					
				$add_itncl							= $this->admin_model->insert_item('icd_token_no_container_list',$data['itncl']);
			}

			$aginl_val 								=  $tkn_no+1;
			$data['aginl']['aginl_val'] 			=  '000'.$aginl_val;
			$edit_aginl 							= $this->admin_model->update_data('auto_generate_id_no_list','aginl_id','6',$data['aginl']);
			
			$data['icdl_details']['icdl_cro_status'] 	= '1';	
			$edit_icdl 									= $this->admin_model->update_data('icd_container_details_list','icdl_id',$icdl_id,$data['icdl_details']);

		}
		
		$data['igedl']['igedl_cro_re_c_no'] 	= $this->input->post('igedl_cro_re_c_no')-1;		
		$data['igedl']['igedl_cro_id'] 			= $this->user['i_user_id'];
		$data['igedl']['igedl_cro_status'] 		= '1';
		$data['igedl']['igedl_cro_date'] 		= date("Y-m-d");		
		
		
		$edit_igedl 			= $this->admin_model->update_data('icd_gate_entry_details_list','igedl_id',$igedl_id,$data['igedl']);

		// echo $this->db->last_query();return;
		
		if($edit_igedl!='0'){
			$this->session->set_flashdata('tos_success', 'Details updated');
			redirect('icd/cro_ctrl/container_selection_release_list');
		}else {
			$this->session->set_flashdata('tos_warning', 'There is no changes!...');
			redirect('icd/cro_ctrl/container_selection_release_list');
		}			
				
	}
	
	/*----------------- load container_selection_release_final_list page -----------------*/
	public function container_selection_release_final_list(){		
		$data['sdata'] 			= array();
		$data['subview'] 		= 'icd/cro/container_selection_release_final_list';		
		$data['active_cls'] 	= 'conedl_cls';	
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');			
		$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','','','','','1','1','0');
		// echo $this->db->last_query();return;
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*----------------- load container_selection_release_final_form page -----------------*/
	public function container_selection_release_final_form($igetl_id){		
		$data['sdata'] 					= array();
		$data['subview'] 				= 'icd/cro/container_selection_release_final_form';		
		$data['active_cls'] 			= 'dash';			
		$data['url_list'] 				= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');			
		
		$data['sdata']['igetl_data'] 		= $this->icd_model->get_icdl_igetl_details_list('','',$igetl_id,'','','','1','1','0');
		// echo $this->db->last_query();return;
		
		$data['sdata']['itncl_list'] 	= $this->icd_model->get_icdl_itncl_details_list('',$igetl_id,'','1','','1');
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*----------------- update_container_release_details -----------------*/
	public function update_container_release_final_details($igetl_id){		
		$this->form_validation->set_rules('igetl_vat_amount', 'VAT Amount', 'trim|required');
		$this->form_validation->set_rules('igetl_invoice_date', 'Invoice Date', 'trim|required');
		$this->form_validation->set_rules('igetl_total_amount', 'Total Amount', 'trim|required');
		$this->form_validation->set_rules('igetl_sub_total', 'Inv Sub Total', 'trim|required');
		$this->form_validation->set_rules('igetl_expiry_date', 'Expiry. Date', 'trim|required');

		
		if ($this->form_validation->run() === FALSE) {
			$e_msg = ''; 			
			$e_msg .= form_error('igetl_vat_amount');   		
			$e_msg .= form_error('igetl_invoice_date');   		
			$e_msg .= form_error('igetl_total_amount');   		
			$e_msg .= form_error('igetl_sub_total');   		
			$e_msg .= form_error('igetl_expiry_date');   		
			$this->session->set_flashdata('tos_error', $e_msg);
			redirect('icd/cro_ctrl/container_selection_release_final_list');	return;	
		}	
		
		
		foreach($_POST as $post_key=>$post_rows){
			if($post_key!='update' && $post_key!='final_update'){
				$data['igetl'][$post_key] 				= $this->input->post($post_key);	
			}	
		}

		$data['igetl']['igetl_cro_id'] 			= $this->user['i_user_id'];
		$data['igetl']['igetl_cro_status'] 		= '1';
		$data['igetl']['igetl_cro_date'] 		= date("Y-m-d");				
		
		if(isset($_POST['final_update'])){
			$data['igetl']['igetl_fnl_update_cro_id'] 			= $this->user['i_user_id'];
			$data['igetl']['igetl_fnl_update_cro_status'] 		= '1';
			$data['igetl']['igetl_fnl_update_cro_date'] 		= date("Y-m-d");	
		}
		
		$edit_igetl 			= $this->admin_model->update_data('icd_gate_entry_token_list','igetl_id',$igetl_id,$data['igetl']);

			
		if($edit_igetl!='0'){
			$this->session->set_flashdata('tos_success', 'Details updated');
			redirect('icd/cro_ctrl/container_selection_release_final_list');
		}else {
			$this->session->set_flashdata('tos_warning', 'There is no changes!...');
			redirect('icd/cro_ctrl/container_selection_release_final_list');
		}			
				
	}

	
}
