<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Pteo_ctrl extends user_icd_index {
 
	
	public function __construct(){
		parent::__construct(); 
		$data = array();
		$this->load->model('admin_model');
		$this->load->model('icd_model');		
	}
	
	/*----------------- load icd details list page -----------------*/
	public function port_entry_list(){	 	
		$data['sdata'] 			= array();
		$data['subview'] 		= 'icd/pteo/port_entry_list';		
		$data['active_cls'] 	= 'dash';	
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');			
		$data['sdata']['idl_list'] 		= $this->icd_model->get_icd_details_list('','1','0');
		$this->load->view('icd/common/icd_sidepanel',$data);  
	}

	/*----------------- load port_entry_update page -----------------*/
	public function port_entry_update($idl_id){		
		$data['sdata'] 			= array();
		$data['subview'] 		= 'icd/pteo/port_entry_update';		
		$data['active_cls'] 	= 'dash';			
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');			

		$data['sdata']['isl_list'] 		= $this->admin_model->get_result_array('icd_service_list');	
		$data['sdata']['cul_list'] 		= $this->admin_model->get_result_array('currency_list');	
		$data['sdata']['idl_data'] 		= $this->icd_model->get_icd_details_list($idl_id,'1','0');
		$data['csl_list'] 		= $this->admin_model->get_result_array('container_status_list');
		$data['sdata']['icdl_list'] 	= $this->icd_model->get_icdl_details_list($idl_id);
		// echo $this->db->last_query();return;
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*----------------- update icd details -----------------*/
	public function update_icd_details($idl_id){		
		// var_dump($_POST);return;
		$this->form_validation->set_rules('idl_csl_id', 'Container Status', 'trim|required');		
		$this->form_validation->set_rules('idl_time_in', 'Time In', 'trim|required');
		// $this->form_validation->set_rules('idl_vat', 'VAT Applicable', 'trim|required');
		$this->form_validation->set_rules('idl_proforma_invoice', 'Proforma Invoice', 'trim|required');
		$this->form_validation->set_rules('idl_destination', 'Destination', 'trim|required');
		$this->form_validation->set_rules('idl_bill_refer', 'Billing Reference ', 'trim|required');

		
		if ($this->form_validation->run() === FALSE) {
			$e_msg = ''; 			
			$e_msg .= form_error('idl_csl_id');   			
			$e_msg .= form_error('idl_time_in');   			
			// $e_msg .= form_error('idl_vat'); 
			$e_msg .= form_error('idl_proforma_invoice'); 
			$e_msg .= form_error('idl_destination'); 
			$e_msg .= form_error('idl_bill_refer');   	
			$this->session->set_flashdata('tos_error', $e_msg);
			redirect('icd/pteo_ctrl/port_entry_list');	return;			
			
		}	
		$data['idl_details'] = array();
		foreach($_POST as $post_key=>$post_rows){
			if($post_key!='icdl_id' && $post_key!='icdl_isl_id' && $post_key!='icdl_cul_id' && $post_key!='icdl_sub_total' && $post_key!='icdl_vat' && $post_key!='icdl_total' && $post_key!='icdl_remarks' && $post_key!='icdl_c_status' && $post_key!='icdl_handling_charges' && $post_key!='icdl_levy'){
				$data['idl_details'][$post_key] 		= $this->input->post($post_key);
			}
		}
		$data['idl_details']['idl_pteo_id'] 			= $this->user['i_user_id'];
		$data['idl_details']['idl_pteo_status'] 		= '1';
		$data['idl_details']['idl_pteo_date'] 			= date("Y-m-d");
		
		$edit_idl 				= $this->admin_model->update_data('icd_details_list','idl_id',$idl_id,$data['idl_details']);

		$icdl_id 				= $this->input->post('icdl_id');
		$icdl_c_status 			= $this->input->post('icdl_c_status');
		$icdl_isl_id 			= $this->input->post('icdl_isl_id');
		$icdl_cul_id 			= $this->input->post('icdl_cul_id');
		$icdl_handling_charges 	= $this->input->post('icdl_handling_charges');
		$icdl_levy 				= $this->input->post('icdl_levy');
		$icdl_sub_total 		= $this->input->post('icdl_sub_total');
		$icdl_vat 				= $this->input->post('icdl_vat');
		$icdl_total 			= $this->input->post('icdl_total');
		$icdl_remarks 			= $this->input->post('icdl_remarks');
		 

		foreach($icdl_id as $icdl_key=>$icdl_row){				
			$data['icdl_details']['icdl_id'] 					=  $icdl_row;
			$data['icdl_details']['icdl_c_status'] 				=  $icdl_c_status[$icdl_key];
			$data['icdl_details']['icdl_isl_id'] 				=  $icdl_isl_id[$icdl_key];
			$data['icdl_details']['icdl_cul_id'] 				=  $icdl_cul_id[$icdl_key];
			$data['icdl_details']['icdl_handling_charges'] 		=  $icdl_handling_charges[$icdl_key];
			$data['icdl_details']['icdl_levy'] 					=  $icdl_levy[$icdl_key];
			$data['icdl_details']['icdl_sub_total'] 			=  $icdl_sub_total[$icdl_key];
			$data['icdl_details']['icdl_vat'] 					=  $icdl_vat[$icdl_key];
			$data['icdl_details']['icdl_total'] 				=  $icdl_total[$icdl_key];
			$data['icdl_details']['icdl_remarks'] 				=  $icdl_remarks[$icdl_key];	
			$edit_icdl 											= $this->admin_model->update_data('icd_container_details_list','icdl_id',$icdl_row,$data['icdl_details']);	
		}
				
		if($edit_idl!='0'){
			$this->session->set_flashdata('tos_success', 'Details updated');
			redirect('icd/pteo_ctrl/port_entry_list');
		}else {
			$this->session->set_flashdata('tos_warning', 'There is no changes!...');
			redirect('icd/pteo_ctrl/port_entry_list');
		}			
				
	}
	
	
	
	
}
