<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Transit_material_ctrl extends user_icd_index {
 
	
	public function __construct(){
		parent::__construct();  
		$data = array();
		$this->load->model('admin_model');
		$this->load->model('icd_model');		
	}
	
	/*----------------- load icd_container_out_list page -----------------*/
	public function icd_container_out_list(){		
		$data['sdata'] 			= array(); 
		$data['subview'] 		= 'icd/geo/icd_container_out_list';		
		$data['active_cls'] 	= 'conedl_cls';	
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');	
		if(isset($_POST['token_no_val'])){ 
			$token_no = $this->input->post('token_no_val');
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','',$token_no,'2','Transit-Container with Material','1','0');
		}else if(!isset($_POST['token_no_val'])){		
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','','','2','Transit-Container with Material','1','0');
		}
		// echo $this->db->last_query(); return;
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*----------------- load icd_container_out_form page -----------------*/
	public function icd_container_out_form($igedl_id,$igetl_id){		
		$data['sdata'] 					= array();
		$data['subview'] 				= 'icd/geo/icd_container_out_form';		
		$data['active_cls'] 			= 'dash';			
		$data['url_list'] 				= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');		
		$data['sdata']['aginl_no'] 		= $this->admin_model->get_result_array('auto_generate_id_no_list','aginl_id','3');
					
		$data['sdata']['agl_list'] 		= $this->admin_model->get_result_array('agent_list');	
		$data['sdata']['igetl_data'] 		= $this->icd_model->get_icdl_igetl_details_list('',$igedl_id,$igetl_id,'','2','Transit-Container with Material','1','0');		
		$data['sdata']['iidl_list'] 	= $this->icd_model->get_icdl_ivcl_details_list('',$igedl_id,'','1');
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*----------------- update_container_release_details -----------------*/
	public function update_icd_container_out_details($igetl_id){		
		$this->form_validation->set_rules('igetl_icd_out_no', 'ICD Out No', 'trim|required');
		$this->form_validation->set_rules('igetl_driver_name', 'Driver Name', 'trim|required');
		$this->form_validation->set_rules('igetl_driver_lic_no', 'Driver Lic No', 'trim|required');	
		if ($this->form_validation->run() === FALSE) {
			$e_msg = ''; 			
			$e_msg .= form_error('igedl_icd_out_no');   		
			$e_msg .= form_error('igedl_driver_name');   		
			$e_msg .= form_error('igedl_driver_lic_no');   		
			$this->session->set_flashdata('tos_error', $e_msg);
			redirect('icd/transit_material_ctrl/icd_container_out_list');	return;				
		}	
		$data['igetl_details']['igetl_icd_out_no'] 		= $this->input->post('igetl_icd_out_no');
		$data['igetl_details']['igetl_driver_name'] 	= $this->input->post('igetl_driver_name');
		$data['igetl_details']['igetl_driver_lic_no'] 	= $this->input->post('igetl_driver_lic_no');
		
		$data['igetl_details']['igetl_ico_geo_id'] 		= $this->user['i_user_id'];
		$data['igetl_details']['igetl_ico_geo_status'] 	= '1';
		$data['igetl_details']['igetl_ico_geo_date'] 	= date("Y-m-d");
		
		$edit_igetl 			= $this->admin_model->update_data('icd_gate_entry_token_list','igetl_id',$igetl_id,$data['igetl_details']);
		
		

		$aginl_val 							=  $this->input->post('igetl_icd_out_no')+1;
		$data['aginl_details']['aginl_val'] = $aginl_val;
		$edit_aginl 						= $this->admin_model->update_data('auto_generate_id_no_list','aginl_id','3',$data['aginl_details']);
				
		if($edit_igetl!='0'){
			$this->session->set_flashdata('tos_success', 'Details updated');
			redirect('icd/transit_material_ctrl/icd_container_out_list');
		}else {
			$this->session->set_flashdata('tos_warning', 'There is no changes!...');
			redirect('icd/transit_material_ctrl/icd_container_out_list');
		}			
				
	}

	/*----------------- load icd_container_out_print_out_list page -----------------*/
	public function icd_container_out_print_out_list(){		
		$data['sdata'] 			= array();
		$data['subview'] 		= 'icd/geo/icd_container_out_print_out_list';		
		$data['active_cls'] 	= 'conedl_cls';	
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');			
		if(isset($_POST['token_no_val'])){ 
			$token_no = $this->input->post('token_no_val');
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','',$token_no,'2','Transit-Container with Material','1','1','1','0');
		}else if(!isset($_POST['token_no_val'])){		
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','','','2','Transit-Container with Material','1','1','1','0');
		}
		// echo $this->db->last_query();return;
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*----------------- icd_container_out_print_out_proceed -----------------*/
	public function icd_container_out_print_out_proceed($igetl_id){		
		
		$data['igetl_details']['igetl_ico_print_out_geo_id'] 		= $this->user['i_user_id'];
		$data['igetl_details']['igetl_ico_print_out_geo_status'] 	= '1';
		$data['igetl_details']['igetl_ico_print_out_geo_date'] 		= date("Y-m-d");
		
		$edit_igetl 			= $this->admin_model->update_data('icd_gate_entry_token_list','igetl_id',$igetl_id,$data['igetl_details']);

		
				
		if($edit_igetl!='0'){
			$this->session->set_flashdata('tos_success', 'Details updated');
			redirect('icd/icd_print_out_ctrl/icd_container_out_proceed_print_out/'.$igedl_id);	
		}else {
			$this->session->set_flashdata('tos_warning', 'There is no changes!...');
			redirect('icd/transit_material_ctrl/icd_container_out_print_out_list');
		}			
				
	}

	/*----------------- load icd_container_out_approve_list page -----------------*/
	public function icd_container_out_approve_list(){		
		$data['sdata'] 			= array();
		$data['subview'] 		= 'icd/iao/icd_container_out_approve_list';		
		$data['active_cls'] 	= 'conedl_cls';	
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');			
		if(isset($_POST['token_no_val'])){ 
			$token_no = $this->input->post('token_no_val');
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','',$token_no,'2','Transit-Container with Material','1','1','0');
		}else if(!isset($_POST['token_no_val'])){		
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','','','2','Transit-Container with Material','1','1','0');
		}
		// echo $this->db->last_query();return;
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*----------------- load icd_container_out_approve_form page -----------------*/
	public function icd_container_out_approve_form($igedl_id,$igetl_id){		
		$data['sdata'] 					= array();
		$data['subview'] 				= 'icd/iao/icd_container_out_approve_form';		
		$data['active_cls'] 			= 'dash';			
		$data['url_list'] 				= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');					
		$data['sdata']['agl_list'] 		= $this->admin_model->get_result_array('agent_list');	
		$data['sdata']['igetl_data'] 		= $this->icd_model->get_icdl_igetl_details_list('',$igedl_id,$igetl_id,'','2','Transit-Container with Material','1','1','0');	

		$data['sdata']['iidl_list'] 	= $this->icd_model->get_icdl_ivcl_details_list('',$igedl_id,'','1');
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*----------------- update_icd_container_out_approve_details -----------------*/
	public function update_icd_container_out_approve_details($igetl_id){		
		
		$data['igetl_details']['igetl_icoa_iao_id'] 		= $this->user['i_user_id'];
		$data['igetl_details']['igetl_icoa_iao_status'] 	= '1';
		$data['igetl_details']['igetl_icoa_iao_date'] 	= date("Y-m-d");
		
		$edit_igetl 			= $this->admin_model->update_data('icd_gate_entry_token_list','igetl_id',$igetl_id,$data['igetl_details']);

		
				
		if($edit_igetl!='0'){
			$this->session->set_flashdata('tos_success', 'Details updated');
			redirect('icd/transit_material_ctrl/icd_container_out_approve_list');
		}else {
			$this->session->set_flashdata('tos_warning', 'There is no changes!...');
			redirect('icd/transit_material_ctrl/icd_container_out_approve_list');
		}			
				
	}

	/*----------------- load icd_container_out_local_gate_list page -----------------*/
	public function icd_container_out_local_gate_list(){		
		$data['sdata'] 			= array();
		$data['subview'] 		= 'icd/igeo/icd_container_out_local_gate_list';		
		$data['active_cls'] 	= 'conedl_cls';	
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');			
		if(isset($_POST['token_no_val'])){ 
			$token_no = $this->input->post('token_no_val');
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','',$token_no,'2','Transit-Container with Material','1','1','1','1','0');
		}else if(!isset($_POST['token_no_val'])){		
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','','','2','Transit-Container with Material','1','1','1','1','0');
		}
		// echo $this->db->last_query();return;
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}
 
	/*----------------- load icd_container_out_local_gate_form page -----------------*/
	public function icd_container_out_local_gate_form($igedl_id,$igetl_id){		
		$data['sdata'] 					= array();
		$data['subview'] 				= 'icd/igeo/icd_container_out_local_gate_form';		
		$data['active_cls'] 			= 'dash';			
		$data['url_list'] 				= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');					
		$data['sdata']['agl_list'] 		= $this->admin_model->get_result_array('agent_list');	
		$data['sdata']['igetl_data'] 		= $this->icd_model->get_icdl_igetl_details_list('',$igedl_id,$igetl_id,'','2','Transit-Container with Material','1','1','1','1','0');	
			
		$data['sdata']['iidl_list'] 	= $this->icd_model->get_icdl_ivcl_details_list('',$igedl_id,'','1');
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*----------------- update_icd_container_out_local_gate_details -----------------*/
	public function update_icd_container_out_local_gate_details($igetl_id){		
		$data['igetl_details'] = array();

		foreach($_POST as $post_key=>$post_rows){
			$data['igetl_details'][$post_key] 		= $this->input->post($post_key);			
		}
		$data['igetl_details']['igetl_icolg_igeo_id'] 		= $this->user['i_user_id'];
		$data['igetl_details']['igetl_icolg_igeo_status'] 	= '1';
		$data['igetl_details']['igetl_icolg_igeo_date'] 		= date("Y-m-d");
		
		$edit_igetl 			= $this->admin_model->update_data('icd_gate_entry_token_list','igetl_id',$igetl_id,$data['igetl_details']);

		
				 
		if($edit_igetl!='0'){
			$this->session->set_flashdata('tos_success', 'Details updated');
			redirect('icd/icd_print_out_ctrl/icd_container_out_local_gate_print_out/'.$igetl_id);	
		}else {
			$this->session->set_flashdata('tos_warning', 'There is no changes!...');
			redirect('icd/transit_material_ctrl/icd_container_out_local_gate_list');
		}			
				
	}

	/*----------------- load icd_gate_pass_out_entry_at_local_gate_list page -----------------*/
	public function icd_gate_pass_out_entry_at_local_gate_list(){		
		$data['sdata'] 			= array();
		$data['subview'] 		= 'icd/igeo/icd_gate_pass_out_entry_at_local_gate_list';		
		$data['active_cls'] 	= 'conedl_cls';	
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');			
		if(isset($_POST['token_no_val'])){ 
			$token_no = $this->input->post('token_no_val');
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','',$token_no,'2','Transit-Container with Material','1','1','1','1','1','0');
		}else if(!isset($_POST['token_no_val'])){		
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','','','2','Transit-Container with Material','1','1','1','1','1','0');
		}
		// echo $this->db->last_query();return;
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*----------------- load icd_gate_pass_out_entry_at_local_gate_form page -----------------*/
	public function icd_gate_pass_out_entry_at_local_gate_form($igedl_id,$igetl_id){		
		$data['sdata'] 					= array();
		$data['subview'] 				= 'icd/igeo/icd_gate_pass_out_entry_at_local_gate_form';		
		$data['active_cls'] 			= 'dash';			
		$data['url_list'] 				= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');				
		$data['sdata']['aginl_g_no'] 	= $this->admin_model->get_result_array('auto_generate_id_no_list','aginl_id','4');
			
		$data['sdata']['agl_list'] 		= $this->admin_model->get_result_array('agent_list');	
		$data['sdata']['igetl_data'] 		= $this->icd_model->get_icdl_igetl_details_list('',$igedl_id,$igetl_id,'','2','Transit-Container with Material','1','1','1','1','1','0');	
		
		
		$data['sdata']['iidl_list'] 	= $this->icd_model->get_icdl_ivcl_details_list('',$igedl_id,'','1');
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*----------------- update_icd_gate_pass_out_entry_at_local_gate_details -----------------*/
	public function update_icd_gate_pass_out_entry_at_local_gate_details($igetl_id){		
		$data['igetl_details'] = array(); 

		foreach($_POST as $post_key=>$post_rows){
			$data['igetl_details'][$post_key] 		= $this->input->post($post_key);			
		}
		$data['igetl_details']['igetl_igpoelg_igeo_id'] 		= $this->user['i_user_id'];
		$data['igetl_details']['igetl_igpoelg_igeo_status'] 	= '1';
		$data['igetl_details']['igetl_igpoelg_igeo_date'] 		= date("Y-m-d");
		
		$edit_igetl 			= $this->admin_model->update_data('icd_gate_entry_token_list','igetl_id',$igetl_id,$data['igetl_details']);

		$aginl_val 							=  $this->input->post('igetl_gate_pass_out_no')+1;
		$data['aginl_details']['aginl_val'] = '00'.$aginl_val;
		$edit_aginl 						= $this->admin_model->update_data('auto_generate_id_no_list','aginl_id','4',$data['aginl_details']);
		
		
				
		if($edit_igetl!='0'){
			$this->session->set_flashdata('tos_success', 'Details updated');	
			redirect('icd/transit_material_ctrl/icd_gate_pass_out_entry_at_local_gate_list');				
		}else {
			$this->session->set_flashdata('tos_warning', 'There is no changes!...');
			redirect('icd/transit_material_ctrl/icd_gate_pass_out_entry_at_local_gate_list');
		}			
				
	}

	/*-----------load icd_vehicle_gpo_authorize_at_local_list page (gpo - gate pass out) -----------*/
	public function icd_vehicle_gpo_authorize_at_local_list(){		
		$data['sdata'] 			= array();
		$data['subview'] 		= 'icd/igeo/icd_vehicle_gpo_authorize_at_local_list';		
		$data['active_cls'] 	= 'conedl_cls';	
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');			
		if(isset($_POST['token_no_val'])){ 
			$token_no = $this->input->post('token_no_val');
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','',$token_no,'2','Transit-Container with Material','1','1','1','1','1','1','1','0');
		}else if(!isset($_POST['token_no_val'])){		
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','','','2','Transit-Container with Material','1','1','1','1','1','1','1','0');
		}
		// echo $this->db->last_query();return;
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*---------- load icd_vehicle_gpo_authorize_at_local_form page (gpo - gate pass out) ----------*/
	public function icd_vehicle_gpo_authorize_at_local_form($igedl_id,$igetl_id){		
		$data['sdata'] 					= array();
		$data['subview'] 				= 'icd/igeo/icd_vehicle_gpo_authorize_at_local_form';		
		$data['active_cls'] 			= 'dash';			
		$data['url_list'] 				= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');		
			
		$data['sdata']['agl_list'] 		= $this->admin_model->get_result_array('agent_list');	
		$data['sdata']['igetl_data'] 		= $this->icd_model->get_icdl_igetl_details_list('',$igedl_id,$igetl_id,'','2','Transit-Container with Material','1','1','1','1','1','1','1','0');			
		$data['sdata']['iidl_list'] 	= $this->icd_model->get_icdl_ivcl_details_list('',$igedl_id,'','1');
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*---------- update_icd_vehicle_gpo_authorize_at_local (gpo - gate pass out) _details ----------*/
	public function update_icd_vehicle_gpo_authorize_at_local_details($igetl_id){		
		
		$data['igetl_details']['igetl_igpoal_igeo_id'] 		= $this->user['i_user_id'];
		$data['igetl_details']['igetl_igpoal_igeo_status'] 	= '1';
		$data['igetl_details']['igetl_igpoal_igeo_date'] 	= date("Y-m-d");
		
		$edit_igetl 			= $this->admin_model->update_data('icd_gate_entry_token_list','igetl_id',$igetl_id,$data['igetl_details']);
			
		if($edit_igetl!='0'){
			$this->session->set_flashdata('tos_success', 'Details updated');	
			redirect('icd/icd_print_out_ctrl/icd_vehicle_gpo_authorize_at_local_print_out/'.$igetl_id);				
		}else {
			$this->session->set_flashdata('tos_warning', 'There is no changes!...');
			redirect('icd/transit_material_ctrl/icd_gate_pass_out_entry_at_local_gate_list');
		}			
				
	}

	/*----------------- load icd_gate_pass_out_authorization_at_local_list page -----------------*/
	public function icd_gate_pass_out_authorization_at_local_list(){		
		$data['sdata'] 			= array();
		$data['subview'] 		= 'icd/iomo/icd_gate_pass_out_authorization_at_local_list';		
		$data['active_cls'] 	= 'conedl_cls';	
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');			
		if(isset($_POST['token_no_val'])){ 
			$token_no = $this->input->post('token_no_val');
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','',$token_no,'2','Transit-Container with Material','1','1','1','1','1','1','0');
		}else if(!isset($_POST['token_no_val'])){		
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','','','2','Transit-Container with Material','1','1','1','1','1','1','0');
		}
		// echo $this->db->last_query();return;
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*----------------- load icd_gate_pass_out_authorization_at_local_form page -----------------*/
	public function icd_gate_pass_out_authorization_at_local_form($igedl_id,$igetl_id){		
		$data['sdata'] 					= array();
		$data['subview'] 				= 'icd/iomo/icd_gate_pass_out_authorization_at_local_form';		
		$data['active_cls'] 			= 'dash';			
		$data['url_list'] 				= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');		
			
		$data['sdata']['agl_list'] 		= $this->admin_model->get_result_array('agent_list');	
		$data['sdata']['igetl_data'] 		= $this->icd_model->get_icdl_igetl_details_list('',$igedl_id,$igetl_id,'','2','Transit-Container with Material','1','1','1','1','1','1','0');		
		$data['sdata']['iidl_list'] 	= $this->icd_model->get_icdl_ivcl_details_list('',$igedl_id,'','1');
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*----------------- update_icd_gate_pass_out_authorize_at_local_details -----------------*/
	public function update_icd_gate_pass_out_authorize_at_local_details($igetl_id){		
		$data['igetl_details'] = array(); 

		foreach($_POST as $post_key=>$post_rows){
			$data['igetl_details'][$post_key] 		= $this->input->post($post_key);			
		}
		$data['igetl_details']['igetl_igpoal_iomo_id'] 		= $this->user['i_user_id'];
		$data['igetl_details']['igetl_igpoal_iomo_status'] 	= '1';
		$data['igetl_details']['igetl_igpoal_iomo_date'] 	= date("Y-m-d");
		
		$edit_igetl 			= $this->admin_model->update_data('icd_gate_entry_token_list','igetl_id',$igetl_id,$data['igetl_details']);
				
		if($edit_igetl!='0'){
			$this->session->set_flashdata('tos_success', 'Details updated');	
			redirect('icd/transit_material_ctrl/icd_gate_pass_out_authorization_at_local_list');				
		}else {
			$this->session->set_flashdata('tos_warning', 'There is no changes!...');
			redirect('icd/transit_material_ctrl/icd_gate_pass_out_authorization_at_local_list');
		}			
				
	}


}
