<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Geo_ctrl extends user_icd_index {
 
	
	public function __construct(){
		parent::__construct();  
		$data = array();
		$this->load->model('admin_model');
		$this->load->model('icd_model');		
	}
	
	/*----------------- load icd details list page -----------------*/
	public function gate_entry_details_list(){		
		$data['sdata'] 			= array();
		$data['subview'] 		= 'icd/geo/gate_entry_details_list';		
		$data['active_cls'] 	= 'conedl_cls';	
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');		
		$data['sdata']['idl_list'] 		= $this->icd_model->get_icd_details_list('','1','1','1','1','','1','0');	
		
		// echo $this->db->last_query();return;		
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*----------------- load gate_entry_details_form page -----------------*/
	public function gate_entry_details_form($idl_id){	 	
		$data['sdata'] 					= array();
		$data['subview'] 				= 'icd/geo/gate_entry_details_form';		
		$data['active_cls'] 			= 'dash';			
		$data['url_list'] 				= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');			
	
		$data['sdata']['idl_data'] 		= $this->icd_model->get_icd_details_list($idl_id,'1','1','1','1','','1','0');
		
		$data['sdata']['icdl_list'] 	= $this->icd_model->get_icdl_details_list($idl_id,'','1','','0');
		// echo $this->db->last_query();return;
		
		$data['sdata']['aginl_no'] 		= $this->admin_model->get_result_array('auto_generate_id_no_list','aginl_id','1');
		
		$data['sdata']['tl_list'] 	= $this->admin_model->get_result_array_with_one_where('transporter_list','tl_type','icd');
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*----------------- update icd details -----------------*/
	public function update_icd_gate_entry_details($idl_id){	
		
		$idl_remaining_conatiner 	= $this->input->post('idl_remaining_conatiner');
		$idl_remaining_conatiner_c 	= 0;

		$aginl_no 			= $this->admin_model->get_result_array('auto_generate_id_no_list','aginl_id','1');

		$this->form_validation->set_rules('igedl_initiated_by', 'Initiated By ', 'trim|required');

		
		if ($this->form_validation->run() === FALSE) {
			$e_msg = ''; 			  	
			$e_msg .= form_error('igedl_initiated_by');   	
			$this->session->set_flashdata('tos_error', $e_msg);
			redirect('icd/geo_ctrl/gate_entry_details_list');	return;			
			
		}			
		$data['igedl_details']['igedl_gate_entry_no'] 	= 'ICD-GT-'.$aginl_no['aginl_val'];		
		$data['igedl_details']['igedl_idl_id'] 			= $idl_id;
		$data['igedl_details']['igedl_initiated_by'] 	= $this->input->post('igedl_initiated_by');
		
		$data['igedl_details']['igedl_tno_id'] 			= $this->user['i_user_id'];		
		$data['igedl_details']['igedl_tno_status'] 		= '1';		
		$data['igedl_details']['igedl_tno_date'] 		= date('Y-m-d');	
		
		$data['igedl_details']['igedl_tno_iomo_id'] 	= $this->user['i_user_id'];
		$data['igedl_details']['igedl_tno_iomo_status'] = '1';
		$data['igedl_details']['igedl_tno_iomo_date'] 	= date("Y-m-d");

		$data['igedl_details']['igedl_geo_id'] 			= $this->user['i_user_id'];
		$data['igedl_details']['igedl_geo_status'] 		= '1';
		$data['igedl_details']['igedl_geo_date'] 		= date("Y-m-d");

		$add_igedl 										= $this->admin_model->insert_item('icd_gate_entry_details_list',$data['igedl_details']);

		// var_dump($_POST);return;
		$icdl_id 			= $this->input->post('icdl_id');		
		$icdl_truck_no 		= $this->input->post('icdl_truck_no');
		$icdl_trailer_no 	= $this->input->post('icdl_trailer_no');
		$icdl_driver_name 	= $this->input->post('icdl_driver_name');
		$icdl_license 		= $this->input->post('icdl_license');
		$icdl_transporter 	= $this->input->post('icdl_transporter');
		

		foreach($icdl_id as $icdl_key=>$icdl_row){		
			if($icdl_row!='0'){		
				$data['icdl_details']['icdl_id'] 			=  $icdl_row;
				$data['icdl_details']['icdl_truck_no'] 		=  $icdl_truck_no[$icdl_key];
				$data['icdl_details']['icdl_trailer_no'] 	=  $icdl_trailer_no[$icdl_key];
				$data['icdl_details']['icdl_driver_name'] 	=  $icdl_driver_name[$icdl_key];
				$data['icdl_details']['icdl_license'] 		=  $icdl_license[$icdl_key];
				$data['icdl_details']['icdl_transporter'] 	=  $icdl_transporter[$icdl_key];
				$data['icdl_details']['icdl_geo_status'] 	=  1;
				
				$edit_icdl 									= $this->admin_model->update_data('icd_container_details_list','icdl_id',$icdl_row,$data['icdl_details']);
				
				$data['iidl_details']['iidl_igedl_id'] 		= $add_igedl;
				$data['iidl_details']['iidl_icdl_id'] 		= $icdl_row;
				
				$add_iidl									= $this->admin_model->insert_item('igedl_icdl_details_list',$data['iidl_details']);

				$idl_remaining_conatiner_c = $idl_remaining_conatiner_c+1;

			}
		}

		$idl_remaining_conatiner_val 					= $idl_remaining_conatiner-$idl_remaining_conatiner_c;
		$data['idl_details']['idl_remaining_conatiner'] = $idl_remaining_conatiner_val;
		if($idl_remaining_conatiner_val=='0'){		
			$data['idl_details']['idl_geo_completed_status'] 		= '1';		
		}	

		$edit_idl 			= $this->admin_model->update_data('icd_details_list','idl_id',$idl_id,$data['idl_details']);
		


		
		
		$aginl_val 							= $aginl_no['aginl_val']+1;
		$data['aginl_details']['aginl_val'] = '000'.$aginl_val;
		$edit_aginl 						= $this->admin_model->update_data('auto_generate_id_no_list','aginl_id','1',$data['aginl_details']);
		

// 			if($edit_igedl!='0'){
		if($edit_aginl!='0'){
			$this->session->set_flashdata('tos_success', 'Details updated');
			redirect('icd/geo_ctrl/gate_entry_details_list');
		}else {
			$this->session->set_flashdata('tos_warning', 'There is no changes!...');
			redirect('icd/geo_ctrl/gate_entry_details_list');
		}			
				
	}
	
	/*----------------- load gate_entry_details_print_out_list page -----------------*/
	public function gate_entry_details_print_out_list(){		
		$data['sdata'] 						= array();
		$data['subview'] 					= 'icd/geo/gate_entry_details_print_out_list';		
		$data['active_cls'] 				= 'conedl_cls';	
		$data['url_list'] 					= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');		
		$data['sdata']['igedl_list'] 		= $this->icd_model->get_icd_igedl_details_list('','','','1','1','1','1','0');
		// echo $this->db->last_query();return;		

		$this->load->view('icd/common/icd_sidepanel',$data); 
	}
	
 
	/*----------------- gate_entry_details_proceed_to_print_out -----------------*/
	public function gate_entry_details_proceed_to_print_out($igedl_id){		
		$data['igedl_details']['igedl_geo_printout_id'] 		= $this->user['i_user_id'];
		$data['igedl_details']['igedl_geo_printout_status'] 	= '1';
		$data['igedl_details']['igedl_geo_printout_date'] 		= date("Y-m-d");
		
		$edit_igedl 			= $this->admin_model->update_data('icd_gate_entry_details_list','igedl_id',$igedl_id,$data['igedl_details']);	
				
		if($edit_igedl!='0'){
			$this->session->set_flashdata('tos_success', 'Gate entry details approved.');
			redirect('icd/icd_print_out_ctrl/gate_entry_details_print_out/'.$igedl_id);		
		}else {
			$this->session->set_flashdata('tos_warning', 'There is no changes!...');
			redirect('icd/geo_ctrl/gate_entry_details_print_out_list');
		}		
	}

	/*----------------- load icd_container_out_list page -----------------*/
	public function icd_container_out_list(){		
		$data['sdata'] 			= array(); 
		$data['subview'] 		= 'icd/geo/icd_container_out_list';		
		$data['active_cls'] 	= 'conedl_cls';	
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');	
		if(isset($_POST['token_no_val'])){ 
			$token_no = $this->input->post('token_no_val');
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','',$token_no,'1','Local-Container&Material','1','1','1','1','0');
		}else if(!isset($_POST['token_no_val'])){		
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','','','1','Local-Container&Material','1','1','1','1','0');
		}
		// echo $this->db->last_query(); return;
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*----------------- load icd_container_out_form page -----------------*/
	public function icd_container_out_form($igedl_id,$igetl_id){		
		$data['sdata'] 					= array();
		$data['subview'] 				= 'icd/geo/icd_container_out_form';		
		$data['active_cls'] 			= 'dash';			
		$data['url_list'] 				= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');		
		$data['sdata']['aginl_no'] 		= $this->admin_model->get_result_array('auto_generate_id_no_list','aginl_id','3');
		$data['sdata']['tl_list'] 			= $this->admin_model->get_result_array('transporter_list');				
		$data['sdata']['agl_list'] 		= $this->admin_model->get_result_array('agent_list');	
		$data['sdata']['igetl_data'] 		= $this->icd_model->get_icdl_igetl_details_list('',$igedl_id,$igetl_id,'','1','Local-Container&Material','1','1','1','1','0');		
		$data['sdata']['itncl_list'] 	= $this->icd_model->get_icdl_itncl_details_list('',$igetl_id,'','1','','1');
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*----------------- update_container_release_details -----------------*/
	public function update_icd_container_out_details($igetl_id){		
		$this->form_validation->set_rules('igetl_icd_out_no', 'ICD Out No', 'trim|required');
		$this->form_validation->set_rules('igetl_driver_name', 'Driver Name', 'trim|required');
		$this->form_validation->set_rules('igetl_driver_lic_no', 'Driver Lic No', 'trim|required');	
		
		$this->form_validation->set_rules('igetl_trailer_no', 'Trailer No', 'trim|required');	
		$this->form_validation->set_rules('igetl_truck_no', 'Truck No', 'trim|required');	
		$this->form_validation->set_rules('igetl_transporter', 'Transporter', 'trim|required');	
		
		if ($this->form_validation->run() === FALSE) {
			$e_msg = ''; 			
			$e_msg .= form_error('igedl_icd_out_no');   		
			$e_msg .= form_error('igedl_driver_name');   		
			$e_msg .= form_error('igedl_driver_lic_no');  
			
			$e_msg .= form_error('igetl_trailer_no');  
			$e_msg .= form_error('igetl_truck_no');  
			$e_msg .= form_error('igetl_transporter');  
			$this->session->set_flashdata('tos_error', $e_msg);
			redirect('icd/geo_ctrl/icd_container_out_list');	return;				
		}	
		$data['igetl_details']['igetl_icd_out_no'] 		= $this->input->post('igetl_icd_out_no');
		$data['igetl_details']['igetl_driver_name'] 	= $this->input->post('igetl_driver_name');
		$data['igetl_details']['igetl_driver_lic_no'] 	= $this->input->post('igetl_driver_lic_no');
		
		$data['igetl_details']['igetl_trailer_no'] 	= $this->input->post('igetl_trailer_no');
		$data['igetl_details']['igetl_truck_no'] 	= $this->input->post('igetl_truck_no');
		$data['igetl_details']['igetl_transporter'] 	= $this->input->post('igetl_transporter');
		
		$data['igetl_details']['igetl_ico_geo_id'] 		= $this->user['i_user_id'];
		$data['igetl_details']['igetl_ico_geo_status'] 	= '1';
		$data['igetl_details']['igetl_ico_geo_date'] 	= date("Y-m-d");
		
		$edit_igetl 			= $this->admin_model->update_data('icd_gate_entry_token_list','igetl_id',$igetl_id,$data['igetl_details']);
		
		

		$aginl_val 							=  $this->input->post('igetl_icd_out_no')+1;
		$data['aginl_details']['aginl_val'] = $aginl_val;
		$edit_aginl 						= $this->admin_model->update_data('auto_generate_id_no_list','aginl_id','3',$data['aginl_details']);
				
		if($edit_igetl!='0'){
			$this->session->set_flashdata('tos_success', 'Details updated');
			redirect('icd/geo_ctrl/icd_container_out_list');
		}else {
			$this->session->set_flashdata('tos_warning', 'There is no changes!...');
			redirect('icd/geo_ctrl/icd_container_out_list');
		}			
				
	}

	/*----------------- load icd_container_out_print_out_list page -----------------*/
	public function icd_container_out_print_out_list(){		
		$data['sdata'] 			= array();
		$data['subview'] 		= 'icd/geo/icd_container_out_print_out_list';		
		$data['active_cls'] 	= 'conedl_cls';	
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');			
		if(isset($_POST['token_no_val'])){ 
			$token_no = $this->input->post('token_no_val');
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','',$token_no,'1','Local-Container&Material','1','1','1','1','1','1','0');
		}else if(!isset($_POST['token_no_val'])){		
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','','','1','Local-Container&Material','1','1','1','1','1','1','0');
		}
		// echo $this->db->last_query();return;
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*----------------- icd_container_out_print_out_proceed -----------------*/
	public function icd_container_out_print_out_proceed($igetl_id){		
		
		$data['igetl_details']['igetl_ico_print_out_geo_id'] 		= $this->user['i_user_id'];
		$data['igetl_details']['igetl_ico_print_out_geo_status'] 	= '1';
		$data['igetl_details']['igetl_ico_print_out_geo_date'] 		= date("Y-m-d");
		
		$edit_igetl 			= $this->admin_model->update_data('icd_gate_entry_token_list','igetl_id',$igetl_id,$data['igetl_details']);

		
				
		if($edit_igetl!='0'){
			$this->session->set_flashdata('tos_success', 'Details updated');
			redirect('icd/icd_print_out_ctrl/icd_container_out_proceed_print_out/'.$igetl_id);	
		}else {
			$this->session->set_flashdata('tos_warning', 'There is no changes!...');
			redirect('icd/geo_ctrl/icd_container_out_print_out_list');
		}			
				
	}

	/*-----------load icd_out_local_extra_or_lcl_material_gate1_list page  -----------*/
	public function icd_out_local_extra_or_lcl_material_gate1_list(){		
		$data['sdata'] 			= array();
		$data['subview'] 		= 'icd/geo/icd_out_local_extra_or_lcl_material_gate1_list';		
		$data['active_cls'] 	= 'conedl_cls';	
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');
		if(isset($_POST['token_no_val'])){ 
			$token_no = $this->input->post('token_no_val');
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','',$token_no,'1','Local-LCL/Extra Material','1','1','1','1','','','','','','','','0');
		}else if(!isset($_POST['token_no_val'])){		
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','','','1','Local-LCL/Extra Material','1','1','1','1','','','','','','','','0');
		}
		// echo $this->db->last_query();return;
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*---------- load icd_out_local_extra_or_lcl_material_gate1_form page  ----------*/
	public function icd_out_local_extra_or_lcl_material_gate1_form($igedl_id,$igetl_id){		
		$data['sdata'] 					= array();
		$data['subview'] 				= 'icd/geo/icd_out_local_extra_or_lcl_material_gate1_form';		
		$data['active_cls'] 			= 'dash';			
		$data['url_list'] 				= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');		
		
		$data['sdata']['aginl_no'] 		= $this->admin_model->get_result_array('auto_generate_id_no_list','aginl_id','3');
		$data['sdata']['agl_list'] 		= $this->admin_model->get_result_array('agent_list');	
		$data['sdata']['igetl_data'] 		= $this->icd_model->get_icdl_igetl_details_list('',$igedl_id,$igetl_id,'','1','Local-LCL/Extra Material','1','1','1','1','','','','','','','','0');				 	
		$data['sdata']['itncl_list'] 	= $this->icd_model->get_icdl_itncl_details_list('',$igetl_id,'','1','','1');
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*---------- update update_icd_out_local_extra_or_lcl_material_gate1_details details ----------*/
	public function update_icd_out_local_extra_or_lcl_material_gate1_details($igetl_id){		
		
		$this->form_validation->set_rules('igetl_icd_out_no', 'ICD Out No', 'trim|required');
		$this->form_validation->set_rules('igetl_driver_name', 'Driver Name', 'trim|required');
		$this->form_validation->set_rules('igetl_driver_lic_no', 'Driver Lic No', 'trim|required');	
		if ($this->form_validation->run() === FALSE) {
			$e_msg = ''; 			
			$e_msg .= form_error('igedl_icd_out_no');   		
			$e_msg .= form_error('igedl_driver_name');   		
			$e_msg .= form_error('igedl_driver_lic_no');   		
			$this->session->set_flashdata('tos_error', $e_msg);
			redirect('icd/geo_ctrl/icd_container_out_list');	return;				
		}	
		$data['igetl_details']['igetl_icd_out_no'] 		= $this->input->post('igetl_icd_out_no');
		$data['igetl_details']['igetl_driver_name'] 	= $this->input->post('igetl_driver_name');
		$data['igetl_details']['igetl_driver_lic_no'] 	= $this->input->post('igetl_driver_lic_no');
		
		$data['igetl_details']['igetl_iolelmg_geo_id'] 		= $this->user['i_user_id'];
		$data['igetl_details']['igetl_iolelmg_geo_status'] 	= '1';
		$data['igetl_details']['igetl_iolelmg_geo_date'] 	= date("Y-m-d");

		$edit_igetl 			= $this->admin_model->update_data('icd_gate_entry_token_list','igetl_id',$igetl_id,$data['igetl_details']);

		$aginl_val 							=  $this->input->post('igetl_icd_out_no')+1;
		$data['aginl_details']['aginl_val'] = $aginl_val;
		$edit_aginl 						= $this->admin_model->update_data('auto_generate_id_no_list','aginl_id','3',$data['aginl_details']);
		
		

		$icdl_id 				= $this->input->post('icdl_id');		
		$icdl_extra_good_desc 	= $this->input->post('icdl_extra_good_desc');

		foreach($icdl_id as $icdl_key=>$icdl_row){		
			if($icdl_row!='0'){		
				$data['icdl_details']['icdl_id'] 				=  $icdl_row;
				$data['icdl_details']['icdl_extra_good_desc'] 	=  $icdl_extra_good_desc[$icdl_key];
				$edit_icdl 										= $this->admin_model->update_data('icd_container_details_list','icdl_id',$icdl_row,$data['icdl_details']);			
			}
		}

			
		if($edit_igedl!='0'){
			$this->session->set_flashdata('tos_success', 'Details updated');	
			redirect('icd/geo_ctrl/icd_out_local_extra_or_lcl_material_gate1_list');				
		}else {
			$this->session->set_flashdata('tos_warning', 'There is no changes!...');
			redirect('icd/geo_ctrl/icd_out_local_extra_or_lcl_material_gate1_list');
		}			
				
	}

	/*-----------load icd_out_local_extra_or_lcl_material_proceed_list page  -----------*/
	public function icd_out_local_extra_or_lcl_material_proceed_list(){		
		$data['sdata'] 			= array();
		$data['subview'] 		= 'icd/geo/icd_out_local_extra_or_lcl_material_proceed_list';		
		$data['active_cls'] 	= 'conedl_cls';	
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');			
		if(isset($_POST['token_no_val'])){ 
			$token_no = $this->input->post('token_no_val');
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','',$token_no,'1','Local-LCL/Extra Material','1','1','1','1','','','','','','','','1','1','0');
		}else if(!isset($_POST['token_no_val'])){		
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','','','1','Local-LCL/Extra Material','1','1','1','1','','','','','','','','1','1','0');
		}	
		// echo $this->db->last_query();return;
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}
 
	/*---------- update icd_out_local_extra_or_lcl_material_proceed_details details ----------*/
	public function icd_out_local_extra_or_lcl_material_proceed_details($igetl_id){		
		
			
		$data['igetl_details']['igetl_iolelmg_proceed_geo_id'] 		= $this->user['i_user_id'];
		$data['igetl_details']['igetl_iolelmg_proceed_geo_sataus'] 	= '1';
		$data['igetl_details']['igetl_iolelmg_proceed_geo_date'] 	= date("Y-m-d");
		
		$edit_igetl 			= $this->admin_model->update_data('icd_gate_entry_token_list','igetl_id',$igetl_id,$data['igetl_details']);
			
		if($edit_igetl!='0'){ 
			$this->session->set_flashdata('tos_success', 'Details updated');	
			redirect('icd/icd_print_out_ctrl/icd_out_l_e_or_l_m_proceed_print_out/'.$igetl_id);				
		}else {
			$this->session->set_flashdata('tos_warning', 'There is no changes!...');
			redirect('icd/geo_ctrl/icd_out_local_extra_or_lcl_material_proceed_list');
		}			
				
	}


	/*---------- update icd_out_vehicle_gate_entry_transit_empty_list details ----------*/
	public function icd_out_vehicle_gate_entry_transit_empty_list(){		
		$data['sdata'] 			= array();
		$data['subview'] 		= 'icd/geo/icd_out_vehicle_gate_entry_transit_empty_list';		
		$data['active_cls'] 	= 'conedl_cls';	
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');	
		// $data['sdata']['igedl_list'] 		= $this->icd_model->get_icd_igedl_details_list('','','','1','1','1','1','1','1','1','1','1','1','1','1','','1','','1','Local-Empty Container','','','','','','','','','','','','','','0');	
		if(isset($_POST['token_no_val'])){ 
			$token_no = $this->input->post('token_no_val');
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','',$token_no,'1','Local-Empty Container','1','1','1','1','','','','','','','','','','','','','','','0');
		}else if(!isset($_POST['token_no_val'])){		
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','','','1','Local-Empty Container','1','1','1','1','','','','','','','','','','','','','','','0');
		}
		// echo $this->db->last_query();return;
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*---------- update icd_out_vehicle_gate_entry_transit_empty_form details ----------*/
	public function icd_out_vehicle_gate_entry_transit_empty_form($igetl_id){		
		$data['sdata'] 					= array();
		$data['subview'] 				= 'icd/geo/icd_out_vehicle_gate_entry_transit_empty_form';		
		$data['active_cls'] 			= 'dash';			
		$data['url_list'] 				= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');	

		$data['sdata']['aginl_no'] 		= $this->admin_model->get_result_array('auto_generate_id_no_list','aginl_id','3');


		$data['sdata']['igetl_data'] 		= $this->icd_model->get_icdl_igetl_details_list('','',$igetl_id,'','1','Local-Empty Container','1','1','1','1','','','','','','','','','','','','','','','0');	

		$data['sdata']['itncl_list'] 	= $this->icd_model->get_icdl_itncl_details_list('',$igetl_id,'','1','','1');



		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*---------- update update_icd_out_vehicle_gate_entry_transit_empty_details details ----------*/
	public function update_icd_out_vehicle_gate_entry_transit_empty_details($igetl_id){		
		$aginl_no 		= $this->admin_model->get_result_array('auto_generate_id_no_list','aginl_id','3');
		
		$data['igetl']['igetl_icd_out_no'] 			= 'ICD-OUT-'.$aginl_no['aginl_val'];
		$data['igetl']['igetl_driver_name'] 		= $this->input->post('igetl_driver_name');
		$data['igetl']['igetl_driver_lic_no'] 		= $this->input->post('igetl_driver_lic_no');
		
		$data['igetl']['igetl_iovgete_geo_id'] 		= $this->user['i_user_id'];
		$data['igetl']['igetl_iovgete_geo_status'] 	= '1';
		$data['igetl']['igetl_iovgete_geo_date'] 	= date("Y-m-d");
		
		$edit_igetl 			= $this->admin_model->update_data('icd_gate_entry_token_list','igetl_id',$igetl_id,$data['igetl']);
		
		$aginl_val 							=  $aginl_no['aginl_val']+1;
		$data['aginl_details']['aginl_val'] = $aginl_val;
		$edit_aginl 						= $this->admin_model->update_data('auto_generate_id_no_list','aginl_id','3',$data['aginl_details']);

		if($edit_igetl!='0'){
			$this->session->set_flashdata('tos_success', 'Details updated');	
			redirect('icd/geo_ctrl/icd_out_vehicle_gate_entry_transit_empty_list');					
		}else {
			$this->session->set_flashdata('tos_warning', 'There is no changes!...');
			redirect('icd/geo_ctrl/icd_out_vehicle_gate_entry_transit_empty_list');
		}			
				
	}

	/*---------- update icd_out_vehicle_transit_empty_proceed_list details ----------*/
	public function icd_out_vehicle_transit_empty_proceed_list(){		
		$data['sdata'] 			= array();
		$data['subview'] 		= 'icd/geo/icd_out_vehicle_transit_empty_proceed_list';		
		$data['active_cls'] 	= 'conedl_cls';	
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');
		if(isset($_POST['token_no_val'])){ 
			$token_no = $this->input->post('token_no_val');
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','',$token_no,'1','Local-Empty Container','1','1','1','1','','','','','','','','','','','','','','','1','1','0');
		}else if(!isset($_POST['token_no_val'])){		
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','','','1','Local-Empty Container','1','1','1','1','','','','','','','','','','','','','','','1','1','0');
		}
		// echo $this->db->last_query();return;
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*---------- update update_icd_out_vehicle_transit_empty_proceed_details details ----------*/
	public function update_icd_out_vehicle_transit_empty_proceed_details($igetl_id){		
		
		$data['igetl_details']['igetl_iovgete_proceed_geo_id'] 		= $this->user['i_user_id'];
		$data['igetl_details']['igetl_iovgete_proceed_geo_status'] 	= '1';
		$data['igetl_details']['igetl_iovgete_proceed_geo_date'] 		= date("Y-m-d");
		
		$edit_igetl 			= $this->admin_model->update_data('icd_gate_entry_token_list','igetl_id',$igetl_id,$data['igetl_details']);
				
		if($edit_igetl!='0'){
			$this->session->set_flashdata('tos_success', 'Details updated');	
			redirect('icd/icd_print_out_ctrl/icd_out_vehicle_transit_empty_proceed_print_out/'.$igetl_id);
		}else {
			$this->session->set_flashdata('tos_warning', 'There is no changes!...');
			redirect('icd/geo_ctrl/icd_out_vehicle_transit_empty_proceed_list');
		}			
				
	}

	/*---------- update icd_out_transit_material_list details ----------*/
	public function icd_out_transit_material_list(){		
		$data['sdata'] 			= array();
		$data['subview'] 		= 'icd/geo/icd_out_transit_material_list';		
		$data['active_cls'] 	= 'conedl_cls';	
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');
		
		if(isset($_POST['token_no_val'])){ 
			$token_no = $this->input->post('token_no_val');
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','',$token_no,'2','Transit-Material','1','1','1','1','','','','','','','','','','','','','','','','','','','','','','0');
		}else if(!isset($_POST['token_no_val'])){		
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','','','2','Transit-Material','1','1','1','1','','','','','','','','','','','','','','','','','','','','','','0');
		}
		// echo $this->db->last_query();return;
		
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*---------- load icd_out_transit_material_form  page  ----------*/
	public function icd_out_transit_material_form($igetl_id){		
		$data['sdata'] 					= array();
		$data['subview'] 				= 'icd/geo/icd_out_transit_material_form';		
		$data['active_cls'] 			= 'dash';			
		$data['url_list'] 				= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');	
		
		$data['sdata']['igetl_data'] 		= $this->icd_model->get_icdl_igetl_details_list('','',$igetl_id,'','2','Transit-Material','1','1','1','1','','','','','','','','','','','','','','','','','','','','','','0');			

		$data['sdata']['aginl_u_no'] 		= $this->admin_model->get_result_array('auto_generate_id_no_list','aginl_id','3');
				
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*----------------- update_icd_out_transit_material_details -----------------*/
	public function update_icd_out_transit_material_details($igetl_id){
		$aginl_u_no			= $this->admin_model->get_result_array('auto_generate_id_no_list','aginl_id','3');
		
		$data['igetl'] = array();

		foreach($_POST as $post_key=>$post_rows){
			$data['igetl'][$post_key] 				= $this->input->post($post_key);		
		}		
		$data['igetl']['igetl_otm_icd_out_no'] 		= 'ICD-OUT-'.$aginl_u_no['aginl_val'];		
		$data['igetl']['igetl_otm_date'] 			= date("Y-m-d");		
		$data['igetl']['igetl_otm_geo_id'] 			= $this->user['i_user_id'];
		$data['igetl']['igetl_otm_geo_status'] 		= '1';
		$data['igetl']['igetl_otm_geo_date'] 		= date("Y-m-d");
		
		$edit_igetl 										= $this->admin_model->update_data('icd_gate_entry_token_list','igetl_id',$igetl_id,$data['igetl']);	

		$aginl_val 											=  $aginl_u_no['aginl_val']+1;
		$data['aginl_details']['aginl_val'] 				= $aginl_val;
		$edit_aginl 										= $this->admin_model->update_data('auto_generate_id_no_list','aginl_id','3',$data['aginl_details']);
		
				
		if($edit_igetl!='0'){
			$this->session->set_flashdata('tos_success', 'Details updated');
			redirect('icd/geo_ctrl/icd_out_transit_material_list');		
		}else {
			$this->session->set_flashdata('tos_warning', 'There is no changes!...');
			redirect('icd/geo_ctrl/icd_out_transit_material_list');
		}		
	}

	/*---------- update icd_out_transit_material_proceed_list details ----------*/
	public function icd_out_transit_material_proceed_list(){		
		$data['sdata'] 			= array();
		$data['subview'] 		= 'icd/geo/icd_out_transit_material_proceed_list';		
		$data['active_cls'] 	= 'conedl_cls';	
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');			
		if(isset($_POST['token_no_val'])){ 
			$token_no = $this->input->post('token_no_val');
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','',$token_no,'2','Transit-Material','1','1','1','1','','','','','','','','','','','','','','','','','','','','','','1','1','0');
		}else if(!isset($_POST['token_no_val'])){		
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','','','2','Transit-Material','1','1','1','1','','','','','','','','','','','','','','','','','','','','','','1','1','0');
		}
		// echo $this->db->last_query();return;
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}
 
	/*----------------- update_icd_out_transit_material_proceed_details -----------------*/
	public function update_icd_out_transit_material_proceed_details($igetl_id){	
		$data['igetl_details']['igetl_otm_proceed_geo_id'] 			= $this->user['i_user_id'];
		$data['igetl_details']['igetl_otm_proceed_geo_status'] 		= '1';
		$data['igetl_details']['igetl_otm_proceed_geo_date'] 		= date("Y-m-d");
		
		$edit_igetl 			= $this->admin_model->update_data('icd_gate_entry_token_list','igetl_id',$igetl_id,$data['igetl_details']);	
				
		if($edit_igetl!='0'){
			$this->session->set_flashdata('tos_success', 'Details updated');
			redirect('icd/icd_print_out_ctrl/icd_out_transit_material_proceed_print_out/'.$igetl_id);
		}else {
			$this->session->set_flashdata('tos_warning', 'There is no changes!...');
			redirect('icd/geo_ctrl/icd_out_transit_material_proceed_list');
		}		
	}

	
}
