<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Admin_icd_common_ctrl extends user_icd_index {
 
	
	public function __construct(){
		parent::__construct(); 
		$data = array();
		$this->load->model('admin_model');
		$this->load->model('icd_model');
	}
	
	/*----------------- load icd_service list page -----------------*/
	public function icd_service_list($isl_m_type,$isl_id=''){	
		$data['sdata'] 				= array();
		$data['subview'] 			= 'icd/admin_file/icd_service_list';
		$data['active_cls'] 		= 'serv_cls';
		$data['sdata']['isl_m_type'] = $isl_m_type;		
		$data['sdata']['isl_list'] 	= $this->admin_model->get_result_array_with_one_where('icd_service_list','isl_type','icd');
		// echo $this->db->last_query();return;	
		
		if($isl_id!=''){
			$data['sdata']['view_type'] 	= "Edit";
			$data['sdata']['isl_data'] = $this->admin_model->get_result_array('icd_service_list','isl_id',$isl_id);				
			
		}else{
			$data['sdata']['view_type'] 	= "Add";
		}

		$this->load->view('common/icd_sidepanel',$data);
	}
	
	/*----------------- add icd_service  details and edit icd_service  details -----------------*/
	public function insert_services($isl_m_type,$isl_id= false){	
		$isl_status = 0;	
		$this->form_validation->set_rules('isl_name', 'Name', 'trim|required');
		
		if ($this->form_validation->run() === FALSE) {
			$e_msg = '';
			$e_msg .= form_error('isl_name'); 
			$this->session->set_flashdata('tos_error', $e_msg);
			$isl_status = 1;
		}	
		$data['isl_details'] = array();
		foreach($_POST as $post_key=>$post_rows){
			$data['isl_details'][$post_key] 		= $this->input->post($post_key);
			
		}
		
		if($isl_id==false){
			$add_isl 								= $this->admin_model->insert_item('icd_service_list',$data['isl_details']);		
			
				
			if($add_isl!=false){
				$this->session->set_flashdata('tos_success', 'Service details added.');
				redirect('icd/Admin_icd_common_ctrl/icd_service_list/'.$isl_m_type.'');
			}else {
				$this->session->set_flashdata('tos_error', 'Try again !...');
				redirect('icd/Admin_icd_common_ctrl/icd_service_list/'.$isl_m_type.'');
			}	
						
		}else{
			$edit_isl = $this->admin_model->update_data('icd_service_list','isl_id',$isl_id,$data['isl_details']);

				
			if($edit_isl=='1'){
				$this->session->set_flashdata('tos_success', 'Service details updated');
				redirect('icd/Admin_icd_common_ctrl/icd_service_list/'.$isl_m_type.'');
			}else {
				$this->session->set_flashdata('tos_warning', 'There is no changes!...');
				redirect('icd/Admin_icd_common_ctrl/icd_service_list/'.$isl_m_type.'');
			}
		}
				
	}
	
	/*----------------- load agent list page -----------------*/
	public function agent_list($agl_id=''){	
		$data['sdata'] 				= array();
		$data['subview'] 			= 'icd/admin_file/agent_list';
		$data['active_cls'] 		= 'agnt_cls';	
		$data['sdata']['agl_list'] 	= $this->admin_model->get_result_array('agent_list');
		// echo $this->db->last_query();return;	
		
		if($agl_id!=''){
			$data['sdata']['view_type'] 	= "Edit";
			$data['sdata']['agl_data'] = $this->admin_model->get_result_array('agent_list','agl_id',$agl_id);				
			
		}else{
			$data['sdata']['view_type'] 	= "Add";
		}

		$this->load->view('common/icd_sidepanel',$data);
	}

	/*----------------- add agent  details and edit agent  details -----------------*/
	public function insert_agent_details($agl_id= false){
		$this->form_validation->set_rules('agl_name', 'Name', 'trim|required');
// 		$this->form_validation->set_rules('agl_phone', 'Phone', 'trim|required');
// 		$this->form_validation->set_rules('agl_email', 'Email', 'trim|required');
		
		if ($this->form_validation->run() === FALSE) {
			$e_msg = '';
			$e_msg .= form_error('agl_name'); 
// 			$e_msg .= form_error('agl_phone'); 
// 			$e_msg .= form_error('agl_email'); 
			$this->session->set_flashdata('tos_error', $e_msg);
		}	
		$data['agl_details'] = array();
		foreach($_POST as $post_key=>$post_rows){
			$data['agl_details'][$post_key] 		= $this->input->post($post_key);
			
		}
		
		if($agl_id==false){
			$add_agl 								= $this->admin_model->insert_item('agent_list',$data['agl_details']);		
			
				
			if($add_agl!=false){
				$this->session->set_flashdata('tos_success', 'Agent details added.');
				redirect('icd/Admin_icd_common_ctrl/agent_list');
			}else {
				$this->session->set_flashdata('tos_error', 'Try again !...');
				redirect('icd/Admin_icd_common_ctrl/agent_list');
			}	
						
		}else{
			$edit_agl = $this->admin_model->update_data('agent_list','agl_id',$agl_id,$data['agl_details']);

				
			if($edit_agl=='1'){
				$this->session->set_flashdata('tos_success', 'Agent details updated');
				redirect('icd/Admin_icd_common_ctrl/agent_list');
			}else {
				$this->session->set_flashdata('tos_warning', 'There is no changes!...');
				redirect('icd/Admin_icd_common_ctrl/agent_list');
			}
		}
				
	}

	/*----------------- load importer_list page -----------------*/
	public function importer_list($iml_id=''){	
		$data['sdata'] 				= array();
		$data['subview'] 			= 'icd/admin_file/importer_list';
		$data['active_cls'] 		= 'imprtr_cls';	
		$data['sdata']['iml_list'] 	= $this->admin_model->get_result_array('importer_list');
		// echo $this->db->last_query();return;	
		
		if($iml_id!=''){
			$data['sdata']['view_type'] 	= "Edit";
			$data['sdata']['iml_data'] = $this->admin_model->get_result_array('importer_list','iml_id',$iml_id);				
			
		}else{
			$data['sdata']['view_type'] 	= "Add";
		}

		$this->load->view('common/icd_sidepanel',$data);
	}

	/*----------------- add importer details and edit importer details -----------------*/
	public function insert_importer_details($iml_id= false){
		$this->form_validation->set_rules('iml_name', 'Name', 'trim|required');
		
		if ($this->form_validation->run() === FALSE) {
			$e_msg = '';
			$e_msg .= form_error('iml_name');  
			$this->session->set_flashdata('tos_error', $e_msg);
		}	
		$data['iml_details'] = array();
		foreach($_POST as $post_key=>$post_rows){
			$data['iml_details'][$post_key] 		= $this->input->post($post_key);
			
		}
		
		if($iml_id==false){
			$add_iml 								= $this->admin_model->insert_item('importer_list',$data['iml_details']);		
			
				
			if($add_iml!=false){
				$this->session->set_flashdata('tos_success', 'Importer details added.');
				redirect('icd/Admin_icd_common_ctrl/importer_list');
			}else {
				$this->session->set_flashdata('tos_error', 'Try again !...');
				redirect('icd/Admin_icd_common_ctrl/importer_list');
			}	
						
		}else{
			$edit_iml = $this->admin_model->update_data('importer_list','iml_id',$iml_id,$data['iml_details']);

				
			if($edit_iml=='1'){
				$this->session->set_flashdata('tos_success', 'Importer details updated');
				redirect('icd/Admin_icd_common_ctrl/importer_list');
			}else {
				$this->session->set_flashdata('tos_warning', 'There is no changes!...');
				redirect('icd/Admin_icd_common_ctrl/importer_list');
			}
		}
				
	}





}
