<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Commodity_ctrl extends user_index {
 
	
	public function __construct(){ 
		parent::__construct();
		$data = array();
		$this->load->model('admin_model');	
	}
	
	/*----------------- load commodity list page -----------------*/
	public function commodity_list(){	
		$data['sdata'] 					= array();
		$data['subview'] 				= 'commodity/commodity_list';
		$data['active_cls'] 			= 'com_cls';
		$data['sdata']['com_list'] 		= $this->admin_model->get_result_array('commodity_list');				
		$this->load->view('common/sidepanel',$data);
	}
	

	/*----------------- load add commodity details page ----------------*/
	public function add_commodity_details($com_id=''){	
		$data['sdata'] 						= array();
		$data['subview'] 					= 'commodity/add_commodity_details';
		$data['active_cls'] 				= 'com_coms';	
		if($com_id!=''){
			$data['sdata']['view_type'] 	= "Edit";
			$data['sdata']['com_data'] = $this->admin_model->get_result_array('commodity_list','com_id',$com_id);	
		}else{
			$data['sdata']['view_type'] 	= "Add";
		}
		$this->load->view('common/sidepanel',$data);
	}
	
	
	/*----------------- add commodity  details and edit commodity  details -----------------*/
	public function insert_commodity($com_id= false){		
		$this->form_validation->set_rules('com_name', 'Name', 'trim|required');
		
		if ($this->form_validation->run() === FALSE) {
			$e_msg = '';
			$e_msg .= form_error('com_name');  				  
			$this->session->set_flashdata('tos_error', $e_msg);
			if($com_id==''){
				redirect('commodity_ctrl/commodity_list');				
			}else{
				redirect('commodity_ctrl/commodity_list/'.$com_id);				
			}
		}	
		$data['com_details'] = array();
		foreach($_POST as $post_key=>$post_rows){
			$data['com_details'][$post_key] 		= $this->input->post($post_key);
		}
		

		if($com_id==false){				
			$add_com 						= $this->admin_model->insert_item('commodity_list',$data['com_details']);	
			$data['com_details']['com_code'] = 'COM-'.$add_com;
			$code_com = $this->admin_model->update_data('commodity_list','com_id',$add_com,$data['com_details']);
				
			if($add_com!=false){
				$this->session->set_flashdata('tos_success', 'commodity details added.');
				redirect('commodity_ctrl/commodity_list');
			}else {
				$this->session->set_flashdata('tos_error', 'Try again !...');
				redirect('commodity_ctrl/commodity_list');
			}			
		}else{
			$edit_com = $this->admin_model->update_data('commodity_list','com_id',$com_id,$data['com_details']);
			if($edit_com=='1'){
				$this->session->set_flashdata('tos_success', 'commodity details updated');
				redirect('commodity_ctrl/commodity_list');
			}else {
				$this->session->set_flashdata('tos_warning', 'There is no changes!...');
				redirect('commodity_ctrl/commodity_list/'.$com_id);
			}
		}		
	}

	/*----------------- load Meterial list page -----------------*/
	public function commodity_meterial_list($com_id){	
		$data['sdata'] 					= array();
		$data['subview'] 				= 'commodity/commodity_meterial_list';
		$data['active_cls'] 			= 'com_cls';
		$data['sdata']['ml_list'] 		= $this->admin_model->get_meterial_list('',$com_id);				
		$this->load->view('common/sidepanel',$data);
	}

	/*----------------- load add Meterial details page ----------------*/
	public function add_meterial_details($ml_id=''){	
		$data['sdata'] 						= array();
		$data['subview'] 					= 'commodity/add_meterial_details';
		$data['active_cls'] 				= 'com_cls';
		$data['sdata']['com_list'] 			= $this->admin_model->get_result_array('commodity_list');	
		$data['sdata']['unl_list'] 			= $this->admin_model->get_result_array('units_list');				
		
		if($ml_id!=''){
			$data['sdata']['view_type'] 	= "Edit";
			$data['sdata']['ml_data'] = $this->admin_model->get_meterial_list($ml_id);	
		}else{
			$data['sdata']['view_type'] 	= "Add";
		}
		$this->load->view('common/sidepanel',$data);
	}

	/*----------------- add Meterial  details and edit Meterial  details -----------------*/
	public function insert_meterial($ml_id= false){		
		$this->form_validation->set_rules('ml_com_id', 'Commodity Name', 'trim|required');
		$this->form_validation->set_rules('ml_name', 'Meterial Name', 'trim|required');
		$this->form_validation->set_rules('ml_total_stock', 'Total Stock', 'trim|required');
		$this->form_validation->set_rules('ml_unl_id', 'Unit', 'trim|required');
		$this->form_validation->set_rules('ml_unit_kg', 'Unit kg', 'trim|required');
		
		if ($this->form_validation->run() === FALSE) {
			$e_msg = '';
			$e_msg .= form_error('ml_com_id');  				  
			$e_msg .= form_error('ml_name');  				  
			$e_msg .= form_error('ml_total_stock');  				  
			$e_msg .= form_error('ml_unl_id');  				  
			$e_msg .= form_error('ml_unit_kg');  				  
			$this->session->set_flashdata('tos_error', $e_msg);
			if($ml_id==''){
				redirect('commodity_ctrl/commodity_meterial_list');				
			}else{
				redirect('commodity_ctrl/commodity_meterial_list/'.$_POST['ml_com_id']);				
			}
		}	
		$data['ml_details'] = array();
		foreach($_POST as $post_key=>$post_rows){
			$data['ml_details'][$post_key] 		= $this->input->post($post_key);
		}
		

		if($ml_id==false){				
			$add_ml 						= $this->admin_model->insert_item('meterial_list',$data['ml_details']);		
			$data['ml_details']['ml_code'] = 'IT-'.$add_ml;
			$code_ml = $this->admin_model->update_data('meterial_list','ml_id',$add_ml,$data['ml_details']);
			
			if($add_ml!=false){
				$this->session->set_flashdata('tos_success', 'commodity details added.');
				redirect('commodity_ctrl/commodity_meterial_list/'.$_POST['ml_com_id']);
			}else {
				$this->session->set_flashdata('tos_error', 'Try again !...');
				redirect('commodity_ctrl/commodity_meterial_list/'.$_POST['ml_com_id']);
			}			
		}else{
			$edit_ml = $this->admin_model->update_data('meterial_list','ml_id',$ml_id,$data['ml_details']);
			if($edit_ml=='1'){
				$this->session->set_flashdata('tos_success', 'commodity details updated');
				redirect('commodity_ctrl/commodity_meterial_list/'.$_POST['ml_com_id']);
			}else {
				$this->session->set_flashdata('tos_warning', 'There is no changes!...');
				redirect('commodity_ctrl/commodity_meterial_list/'.$_POST['ml_com_id']);
			}
		}		
	}
	

	
}
