<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Customer_ctrl extends user_index {
 
	
	public function __construct(){ 
		parent::__construct();
		$data = array();
		$this->load->model('admin_model');	
	}
	
	/*----------------- load customer list page -----------------*/
	public function customer_list(){	
		$data['sdata'] 				= array();
		$data['subview'] 			= 'customer/customer_list';
		$data['active_cls'] 		= 'cust_cls';
		$data['sdata']['cl_list'] 	= $this->admin_model->get_result_array('customer_list');				
		$this->load->view('common/sidepanel',$data);
	}
	

	/*----------------- load add customer details page ----------------*/
	public function add_customer_details($cl_id=''){	
		$data['sdata'] 						= array();
		$data['subview'] 					= 'customer/add_customer_details';
		$data['active_cls'] 				= 'cust_cls';	
		if($cl_id!=''){
			$data['sdata']['view_type'] 	= "Edit";
			$data['sdata']['cl_data'] = $this->admin_model->get_result_array('customer_list','cl_id',$cl_id);	
		}else{
			$data['sdata']['view_type'] 	= "Add";
		}
		$this->load->view('common/sidepanel',$data);
	}
	
	
	/*----------------- add customer  details and edit customer  details -----------------*/
	public function insert_customer	($cl_id= false){		
		$this->form_validation->set_rules('cl_name', 'Name', 'trim|required');
		$this->form_validation->set_rules('cl_mobile', 'Mobile number', 'trim|required');
		$this->form_validation->set_rules('cl_email', 'Emailid', 'trim|required');
		$this->form_validation->set_rules('cl_state', 'State', 'trim|required');
		$this->form_validation->set_rules('cl_district', 'District', 'trim|required');
		$this->form_validation->set_rules('cl_place', 'Place', 'trim|required');
		$this->form_validation->set_rules('cl_pincode', 'Pincode', 'trim|required');
		$this->form_validation->set_rules('cl_address', 'Address', 'trim|required');
		$this->form_validation->set_rules('cl_tin_no', 'TIN No', 'trim|required');
		$this->form_validation->set_rules('cl_vrn_np', 'VRN Np', 'trim|required');
		$this->form_validation->set_rules('cl_co_name', 'Contact Person Name', 'trim|required');
		$this->form_validation->set_rules('cl_phone', 'Phone No', 'trim|required');
		
		if ($this->form_validation->run() === FALSE) {
			$e_msg = '';
			$e_msg .= form_error('cl_name');  				$e_msg .= form_error('cl_pincode');  			
			$e_msg .= form_error('cl_mobile');   			$e_msg .= form_error('cl_address'); 
			$e_msg .= form_error('cl_email');   			$e_msg .= form_error('cl_state');   
			$e_msg .= form_error('cl_district');   			$e_msg .= form_error('cl_place');   
			$e_msg .= form_error('cl_tin_no');   			$e_msg .= form_error('cl_vrn_np');   
			$e_msg .= form_error('cl_co_name');   			$e_msg .= form_error('cl_phone');   
			$this->session->set_flashdata('tos_error', $e_msg);
			if($cl_id==''){
				redirect('customer_ctrl/customer_list');				
			}else{
				redirect('customer_ctrl/customer_list/'.$cl_id);				
			}
		}	
		$data['cl_details'] = array();
		foreach($_POST as $post_key=>$post_rows){
			$data['cl_details'][$post_key] 		= $this->input->post($post_key);
		}
		

		if($cl_id==false){				
			$add_cl 						= $this->admin_model->insert_item('customer_list',$data['cl_details']);		
			$data['cl_details']['cl_code'] = 'CU-'.$add_cl;
			$code_cl = $this->admin_model->update_data('customer_list','cl_id',$add_cl,$data['cl_details']);
			
			if($add_cl!=false){
				$this->session->set_flashdata('tos_success', 'Customer details added.');
				redirect('customer_ctrl/customer_list');
			}else {
				$this->session->set_flashdata('tos_error', 'Try again !...');
				redirect('customer_ctrl/customer_list');
			}			
		}else{
			$edit_cl = $this->admin_model->update_data('customer_list','cl_id',$cl_id,$data['cl_details']);
			if($edit_cl=='1'){
				$this->session->set_flashdata('tos_success', 'Customer details updated');
				redirect('customer_ctrl/customer_list');
			}else {
				$this->session->set_flashdata('tos_warning', 'There is no changes!...');
				redirect('customer_ctrl/customer_list/'.$cl_id);
			}
		}		
	}

	
	

	
}
