<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Unloading_ctrl extends user_index {
 
	
	public function __construct(){ 
		parent::__construct();
		$data = array();
		$this->load->model('admin_model');	
		$this->load->model('loading_model');	
	}
	
	/*----------------- load unloading vehicle  entry list page -----------------*/
	public function unloading_list(){	
		$data['sdata'] 				= array();
		$data['subview'] 			= 'unloading/unloading_list';
		$data['active_cls'] 		= 'unloadaa_cls';		
		$data['sdata']['lul_list'] 			= $this->loading_model->get_loading_list('Unloading');		
		$this->load->view('common/sidepanel',$data);
	}
	
	/*----------------- load loading vehicle  entry details page -----------------*/
	public function unloading_details_list($lul_id){	
		$data['sdata'] 				= array();
		$data['subview'] 			= 'unloading/unloading_details_list';
		$data['active_cls'] 		= 'unloadaa_cls';		
		$data['sdata']['lul_data'] 			= $this->loading_model->get_loading_list('Unloading',$lul_id);
		$data['sdata']['luml_data'] 		= $this->loading_model->get_loading_or_unloading_meterial_list($lul_id);		
		$this->load->view('common/sidepanel',$data);
	}
	

	/*----------------- load add unloading vehicle  entry details page ----------------*/
	public function add_unloading_vehicle_entry_details($lul_id=''){
		if($this->user['panel_type']=='1' && in_array("1", $this->u_roles)){		
			$data['sdata'] 						= array();
			$data['subview'] 					= 'unloading/add_u_vehicle_entry_details';
			$data['active_cls'] 				= 'unloadaa_cls';	
			$data['sdata']['cl_list'] 			= $this->admin_model->get_result_array('customer_list');				
			$data['sdata']['tl_list'] 			= $this->admin_model->get_result_array('transporter_list');				
			$data['sdata']['com_list'] 			= $this->admin_model->get_result_array('commodity_list');		
			$data['sdata']['unl_list'] 			= $this->admin_model->get_result_array('units_list');		
			$data['sdata']['ml_list'] 			= $this->admin_model->get_meterial_list();	
			$data['sdata']['lul_count'] 		= $this->admin_model->get_counts('loading_unloading_list');	
			if($lul_id!=''){
				$data['sdata']['view_type'] 	= "Edit";
				$data['sdata']['lul_data'] = $this->admin_model->get_result_array('loading_unloading_list','lul_id',$lul_id);	
			}else{
				$data['sdata']['view_type'] 	= "Add";
			}
			$this->load->view('common/sidepanel',$data);
		}else{
			redirect('login_ctrl/logout');
		}
	}
	
	
	/*----------------- add unloading vehicle  entry  details and edit unloading vehicle  entry  details -----------------*/
	public function insert_unloading_details($lul_id= false){	
		if(($this->user['panel_type']!='1') && (!in_array("1", $this->u_roles))){
			redirect('login_ctrl/logout');
		}

		$this->form_validation->set_rules('lul_date', 'Date', 'trim|required');
		$this->form_validation->set_rules('lul_token_no', 'Token', 'trim|required');
		$this->form_validation->set_rules('lul_cl_id', 'Customer', 'trim|required');
		$this->form_validation->set_rules('lul_dn_or_bl_no', 'DN or BL No', 'trim|required');
		$this->form_validation->set_rules('lul_truck_no', 'Truck No', 'trim|required');
		$this->form_validation->set_rules('lul_no_of_bag', 'No of Bags', 'trim|required');
		$this->form_validation->set_rules('lul_tl_id', 'Transporter', 'trim|required');
		$this->form_validation->set_rules('lul_ton', 'Ton', 'trim|required');
		$this->form_validation->set_rules('lul_driver_name', 'Driver name', 'trim|required');
		$this->form_validation->set_rules('lul_driver_ph_no', 'Driver phone no', 'trim|required');
		$this->form_validation->set_rules('lul_lic', 'Driver Lic', 'trim|required');
		$this->form_validation->set_rules('lul_trailer_no', 'Trailer no', 'trim|required');
		$this->form_validation->set_rules('lul_time_in', 'Time in', 'trim|required');
		$this->form_validation->set_rules('lul_com_id', 'Commodity', 'trim|required');
		$this->form_validation->set_rules('lul_container_no', 'Container No', 'trim|required');
		
		if ($this->form_validation->run() === FALSE) {
			$e_msg = '';
			$e_msg .= form_error('lul_date');  				$e_msg .= form_error('lul_token_no');  			
			$e_msg .= form_error('lul_cl_id');   			$e_msg .= form_error('lul_dn_or_bl_no'); 
			$e_msg .= form_error('lul_truck_no');   		$e_msg .= form_error('lul_no_of_bag');   
			$e_msg .= form_error('lul_tl_id');   			$e_msg .= form_error('lul_ton');   
			$e_msg .= form_error('lul_driver_name');   		$e_msg .= form_error('lul_driver_ph_no');   
			$e_msg .= form_error('lul_lic');   			    $e_msg .= form_error('lul_time_in');
			$e_msg .= form_error('lul_trailer_no');			$e_msg .= form_error('lul_com_id');
			$e_msg .= form_error('lul_container_no');  
			$this->session->set_flashdata('tos_error', $e_msg);
			redirect('unloading_ctrl/add_unloading_vehicle_entry_details');	return;			
			
		}	
		$data['lul_details'] = array();
		foreach($_POST as $post_key=>$post_rows){
			if($post_key!='luml_ml_id' && $post_key!='luml_unl_id' && $post_key!='luml_total_weight' && $post_key!='luml_no_of_bag' && $post_key!='bal_bag'){
				$data['lul_details'][$post_key] 		= $this->input->post($post_key);
			}
		}
		
		$data['lul_details']['lul_e_o_id'] 			= $this->user['i_user_id'];
		$data['lul_details']['lul_e_o_date_time'] 	= date("Y-m-d h:i a");
		$data['lul_details']['lul_type'] 			= "unloading";
		if($lul_id==false){				
			$add_lul 						= $this->admin_model->insert_item('loading_unloading_list',$data['lul_details']);	
			
			$luml_ml_id 					= $this->input->post('luml_ml_id');
			$luml_unl_id 					= $this->input->post('luml_unl_id');
			$luml_total_weight 				= $this->input->post('luml_total_weight');
			$luml_no_of_bag 				= $this->input->post('luml_no_of_bag');
			$bal_bag 						= $this->input->post('bal_bag');

			foreach($luml_ml_id as $luml_key=>$luml_row){
				$data['luml_details']['luml_ml_id'] 		=  $luml_row;
				$data['luml_details']['luml_unl_id'] 		=  $luml_unl_id[$luml_key];
				$data['luml_details']['luml_total_weight'] 	=  $luml_total_weight[$luml_key];
				$data['luml_details']['luml_no_of_bag'] 	=  $luml_no_of_bag[$luml_key];
				$data['luml_details']['luml_lul_id'] 		=  $add_lul;							
				$add_luml 									= $this->admin_model->insert_item('loading_unloading_meterial_list',$data['luml_details']);		
				// $data['ml_details']['ml_total_stock'] 		=  $bal_bag[$luml_key];	
				// $edit_ml 									= $this->admin_model->update_data('meterial_list','ml_id',$luml_row,$data['ml_details']);
			}
				
			if($add_lul!=false){
				$this->session->set_flashdata('tos_success', 'Unloading details added.');
				redirect('unloading_ctrl/add_unloading_vehicle_entry_details');
			}else {
				$this->session->set_flashdata('tos_error', 'Try again !...');
				redirect('unloading_ctrl/add_unloading_vehicle_entry_details');
			}			
		}else{
			$edit_lul = $this->admin_model->update_data('loading_unloading_list','lul_id',$lul_id,$data['lul_details']);
			if($edit_lul=='1'){
				$this->session->set_flashdata('tos_success', 'Unloading details updated');
				redirect('unloading_ctrl/add_unloading_vehicle_entry_details');
			}else {
				$this->session->set_flashdata('tos_warning', 'There is no changes!...');
				redirect('unloading_ctrl/add_unloading_vehicle_entry_details/'.$lul_id);
			}
		}		
	}

	/*----------------- load unload gate pass page ----------------*/
	public function unload_gate_pass(){	
		if(($this->user['panel_type']=='1' && in_array("1", $this->u_roles))|| (($this->user['panel_type']=='2') && (in_array("2", $this->u_roles)))){			
			$data['sdata'] 						= array();
			$data['subview'] 					= 'unloading/unload_gate_pass';
			$data['active_cls'] 				= 'unloadaa_cls';				
			$data['sdata']['lul_list'] 			= $this->loading_model->get_loading_list('Unloading');
			// echo $this->db->last_query();return;
			$this->load->view('common/sidepanel',$data);
		}else{
			redirect('login_ctrl/logout');
		}
	}
	

	/*----------------- check vehicle emptyzz ----------------*/
	public function check_vehicle_empty($lul_id){	
		if(($this->user['panel_type']=='1' && in_array("1", $this->u_roles))|| (($this->user['panel_type']=='2') && (in_array("2", $this->u_roles)))){					
			$data['sdata'] 						= array();
			$data['subview'] 					= 'unloading/check_vehicle_empty';
			$data['active_cls'] 				= 'unloadaa_cls';				
			$data['sdata']['lul_data'] 			= $this->loading_model->get_loading_list('Unloading',$lul_id);
			$data['sdata']['luml_data'] 		= $this->loading_model->get_loading_or_unloading_meterial_list($lul_id);	
			// echo $this->db->last_query();return;
			$this->load->view('common/sidepanel',$data);
		}else{
			redirect('login_ctrl/logout');
		}
	}
		
		
	
	/*----------------- submit_vehicle_empty_gatepass -----------------*/
	public function submit_vehicle_empty_gatepass($lul_id= false){
		if(($this->user['panel_type']=='1' && in_array("1", $this->u_roles))|| (($this->user['panel_type']=='2') && (in_array("2", $this->u_roles)))){	
				
			$this->form_validation->set_rules('lul_load_by', 'Unload  By', 'trim|required');
			$this->form_validation->set_rules('lul_l_name', 'Name', 'trim|required');
			$this->form_validation->set_rules('lul_bag_loaded', 'Bags Unloaded', 'trim|required');
			$this->form_validation->set_rules('lul_bag_short', 'Bags(Short)/Excess)', 'trim|required');
			$this->form_validation->set_rules('lul_kgs', 'KGS', 'trim|required');
			
			if ($this->form_validation->run() === FALSE) {
				$e_msg = '';
				$e_msg .= form_error('lul_load_by');  				  
				$e_msg .= form_error('lul_l_name');  				  
				$e_msg .= form_error('lul_bag_loaded');  				  
				$e_msg .= form_error('lul_bag_short');  				  
				$e_msg .= form_error('lul_kgs');  				  
				$this->session->set_flashdata('tos_error', $e_msg);
				redirect('avso_o_ctrl/vehicle_slip_authorizing/'.$lul_id);				
				
			}	
					
			$data['lul_details']['lul_load_by'] 		= $this->input->post('lul_load_by');
			$data['lul_details']['lul_l_name'] 			= $this->input->post('lul_l_name');
			$data['lul_details']['lul_bag_loaded'] 		= $this->input->post('lul_bag_loaded');
			$data['lul_details']['lul_bag_short'] 		= $this->input->post('lul_bag_short');
			$data['lul_details']['lul_kgs'] 			= $this->input->post('lul_kgs');		
			$data['lul_details']['lul_avso_id'] 		= $this->user['i_user_id'];
			$data['lul_details']['lul_avso_date_time'] 	= date("Y-m-d h:i a");
			
			$edit_lul = $this->admin_model->update_data('loading_unloading_list','lul_id',$lul_id,$data['lul_details']);

				
			if($edit_lul!=false){
				$this->session->set_flashdata('tos_success', 'Loading vehicle slip authorized details updated.');
				redirect('print_ctrl/print_gate_pass_view_unloading/'.$lul_id);
			}else {
				$this->session->set_flashdata('tos_error', 'Try again !...');
				redirect('avso_o_ctrl/vehicle_slip_authorize_window');
			}	
		}else{
			redirect('login_ctrl/logout');
		}		
			
	}

	
	
	

	
}
