<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Cvo_ctrl extends user_icd_index {
 
	
	public function __construct(){
		parent::__construct();  
		$data = array();
		$this->load->model('admin_model');
		$this->load->model('icd_model');		
	}
	
	/*----------------- load icd_container_cvo_verify_list page -----------------*/
	public function icd_container_cvo_verify_list(){		
		$data['sdata'] 			= array();
		$data['subview'] 		= 'icd/cvo/icd_container_cvo_verify_list';		
		$data['active_cls'] 	= 'conedl_cls';	
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');			
		$data['sdata']['igedl_list'] 		= $this->icd_model->get_icd_igedl_details_list('','','','1','1','1','1','1','1','1','1','1','0');
		// echo $this->db->last_query();return;
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*----------------- load icd_container_cvo_verify_form page -----------------*/
	public function icd_container_cvo_verify_form($igedl_id){		
		$data['sdata'] 					= array();
		$data['subview'] 				= 'icd/cvo/icd_container_cvo_verify_form';		
		$data['active_cls'] 			= 'dash';			
		$data['url_list'] 				= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');			
		
		$data['sdata']['agl_list'] 		= $this->admin_model->get_result_array('agent_list');			
		$data['sdata']['iml_list'] 		= $this->admin_model->get_result_array('importer_list');			
	
		$data['sdata']['igedl_data'] 	= $this->icd_model->get_icd_igedl_details_list('',$igedl_id,'','1','1','1','1','1','1','1','1','1','0');
		// echo $this->db->last_query();return;
		
		$data['sdata']['icdl_list'] 	= $this->icd_model->get_icdl_details_list($data['sdata']['igedl_data']['idl_id'],'','1','0');
		// var_dump($data['sdata']['iidl_list']);return;
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*----------------- update update_truck_nominationy_details  -----------------*/
	public function update_icd_container_cvo_verify_details($igedl_id){		
		
		$this->form_validation->set_rules('igedl_importer_name', 'Importer Name', 'trim|required');
		$this->form_validation->set_rules('igedl_agl_id', 'Agent Name', 'trim|required');
		$this->form_validation->set_rules('igedl_regi_no', 'Registration No', 'trim|required');
		

		if ($this->form_validation->run() === FALSE) {
			$e_msg = ''; 			
			$e_msg .= form_error('igedl_importer_name');   			
			$e_msg .= form_error('igedl_agl_id');   		
			$e_msg .= form_error('igedl_regi_no');   		
			$this->session->set_flashdata('tos_error', $e_msg);
			redirect('icd/cvo_ctrl/icd_container_cvo_verify_list');	return;			
			
		}	
		$data['igedl_details']['igedl_importer_name'] 	= $this->input->post('igedl_importer_name');
		$data['igedl_details']['igedl_agl_id'] 			= $this->input->post('igedl_agl_id');
		$data['igedl_details']['igedl_regi_no'] 		= $this->input->post('igedl_regi_no');

		$data['igedl_details']['igedl_verify_cvo_id'] 		= $this->user['i_user_id'];
		$data['igedl_details']['igedl_verify_cvo_status'] 	= '1';
		$data['igedl_details']['igedl_verify_cvo_date'] 	= date("Y-m-d");
		$edit_igedl 										= $this->admin_model->update_data('icd_gate_entry_details_list','igedl_id',$igedl_id,$data['igedl_details']);

		$ivcl_icdl_id 			= $this->input->post('ivcl_icdl_id');
		

		foreach($ivcl_icdl_id as $ivcl_key=>$ivcl_row){		
			if($ivcl_row!='0'){		
				$data['icdl_details']['icdl_cvo_status'] 	=  '1';
				$edit_icdl 									= $this->admin_model->update_data('icd_container_details_list','icdl_id',$ivcl_row,$data['icdl_details']);	

				$data['iidl_details']['ivcl_igedl_id'] 			=  $igedl_id;
				$data['iidl_details']['ivcl_icdl_id'] 			=  $ivcl_row;
				
				$add_iidl									= $this->admin_model->insert_item('icd_verified_container_list',$data['iidl_details']);

			}
		}
		

		if($edit_igedl!='0'){
			$this->session->set_flashdata('tos_success', 'Details updated');
			redirect('icd/cvo_ctrl/icd_container_cvo_verify_list');
		}else {
			$this->session->set_flashdata('tos_warning', 'There is no changes!...');
			redirect('icd/cvo_ctrl/icd_container_cvo_verify_list');
		}			
				
	}

	/*----------------- load icd_container_cvo_verify_print_list page -----------------*/
	public function icd_container_cvo_verify_print_list(){		
		$data['sdata'] 			= array();
		$data['subview'] 		= 'icd/cvo/icd_container_cvo_verify_print_list';		
		$data['active_cls'] 	= 'conedl_cls';	
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');			
		$data['sdata']['ivcl_list'] 		= $this->icd_model->get_ivcl_verification_list('');
// 		echo $this->db->last_query();return;
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*----------------- update_icd_container_cvo_verify_print_details -----------------*/
	public function update_icd_container_cvo_verify_print_details(){		
		// var_dump($_POST['igedl_id']);return;
		foreach($_POST['igedl_id'] as $igedl_row){
			$data['igedl_details']['igedl_verify_print_cvo_id'] 		= $this->user['i_user_id'];
			$data['igedl_details']['igedl_verify_print_cvo_status'] 	= '1';
			$data['igedl_details']['igedl_verify_print_cvo_date'] 		= date("Y-m-d");
			
			$edit_igedl 			= $this->admin_model->update_data('icd_gate_entry_details_list','igedl_id',$igedl_row,$data['igedl_details']);	
		}	
		// $this->session->set_flashdata('tos_success', 'Gate entry details approved.');
		redirect('icd/icd_print_out_ctrl/icd_container_cvo_verify_print_out');
	}

	/*----------------- update_icd_container_cvo_verify_print_details -----------------*/
	public function delete_icd_container_cvo_verify_print_details($icdl_id){		
		$data['icdl']['icdl_container_cvo_delete'] 		= '0';
			
		$edit_igedl 			= $this->admin_model->update_data('icd_container_details_list','icdl_id',$icdl_id,$data['icdl']);	
		
		$this->session->set_flashdata('tos_success', 'Container details deleted');
		redirect('icd/cvo_ctrl/icd_container_cvo_verify_print_list');
	}



	/*----------------- load container_verification_list page -----------------*/
	public function container_verification_list(){		
		$data['sdata'] 			= array();
		$data['subview'] 		= 'icd/cvo/container_verification_list';		
		$data['active_cls'] 	= 'conedl_cls';	
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');			
		// $data['sdata']['igedl_list'] 		= $this->icd_model->get_icd_igedl_details_list('','','','1','1','1','1','1','1','1','1','1','0');
		$data['sdata']['igedl_list'] 		= $this->icd_model->get_icd_igedl_details_list('','','','1','1','1','1','1','1','1','1','1','1','1','0');
		// echo $this->db->last_query();return;
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*----------------- load container_verification_form page -----------------*/
	public function container_verification_form($igedl_id){		
		$data['sdata'] 					= array();
		$data['subview'] 				= 'icd/cvo/container_verification_form';		
		$data['active_cls'] 			= 'dash';			
		$data['url_list'] 				= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');			
		
		$data['sdata']['agl_list'] 		= $this->admin_model->get_result_array('agent_list');			
	
		$data['sdata']['igedl_data'] 	= $this->icd_model->get_icd_igedl_details_list('',$igedl_id,'','1','1','1','1','1','1','1','1','1','1','1','0');
		$data['sdata']['icdl_list'] 	= $this->icd_model->get_icdl_details_list($data['sdata']['igedl_data']['idl_id'],'','1','');
		// $data['sdata']['iidl_list'] 	= $this->icd_model->get_icdl_iidl_details_list('',$igedl_id,'','1');
		// echo $this->db->last_query();return;
		
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*----------------- update_container_verification_details -----------------*/
	public function update_container_verification_details($igedl_id){		
	
			
		$data['igedl_details']['igedl_cvo_id'] 			= $this->user['i_user_id'];
		$data['igedl_details']['igedl_cvo_status'] 		= '1';
		$data['igedl_details']['igedl_cvo_date'] 		= date("Y-m-d");
		
		$edit_igedl 			= $this->admin_model->update_data('icd_gate_entry_details_list','igedl_id',$igedl_id,$data['igedl_details']);

		$icdl_id 						= $this->input->post('icdl_id');
		$icdl_verification_cycle 		= $this->input->post('icdl_verification_cycle');
		$icdl_new_seal_no 				= $this->input->post('icdl_new_seal_no');
		$icdl_stripping 				= $this->input->post('icdl_stripping');   
		// $icdl_extra_field 				= $this->input->post('icdl_extra_field');   
		

		foreach($icdl_id as $icdl_key=>$icdl_row){				
			// $data['icdl_details']['icdl_id'] 						=  $icdl_row;
			$data['icdl_details']['icdl_verification_cycle'] 		=  $icdl_verification_cycle[$icdl_key];
			$data['icdl_details']['icdl_new_seal_no'] 				=  $icdl_new_seal_no[$icdl_key];
			$data['icdl_details']['icdl_stripping'] 				=  $icdl_stripping[$icdl_key];	
			// $data['icdl_details']['icdl_extra_field'] 				=  $icdl_extra_field[$icdl_key];	

			$edit_icdl 									= $this->admin_model->update_data('icd_container_details_list','icdl_id',$icdl_row,$data['icdl_details']);
			
			$ivcl_re = $this->admin_model->get_result_array_with_two_where('icd_verified_container_list','ivcl_igedl_id',$igedl_id,'ivcl_icdl_id',$icdl_row);
			if(isset($ivcl_re) && sizeOf($ivcl_re)==0){
				$data['ivcl_details']['ivcl_igedl_id'] 			=  $igedl_id;
				$data['ivcl_details']['ivcl_icdl_id'] 			=  $icdl_row;					
				$add_ivcl									= $this->admin_model->insert_item('icd_verified_container_list',$data['ivcl_details']);
			}
			// echo $this->db->last_query();
			
		}

		// return;		
		if($edit_igedl!='0'){
			$this->session->set_flashdata('tos_success', 'Details updated');
			redirect('icd/cvo_ctrl/container_verification_list');
		}else {
			$this->session->set_flashdata('tos_warning', 'There is no changes!...');
			redirect('icd/cvo_ctrl/container_verification_list');
		}			
				
	}
	

	
}
