<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Igeo_ctrl extends user_icd_index {
 
	
	public function __construct(){
		parent::__construct();  
		$data = array();
		$this->load->model('admin_model');
		$this->load->model('icd_model');		
	}
	
	/*----------------- load icd_gate_entry_authorization_list page -----------------*/
	public function icd_gate_entry_authorization_list(){		
		$data['sdata'] 			= array();
		$data['subview'] 		= 'icd/igeo/icd_gate_entry_authorization_list';		
		$data['active_cls'] 	= 'conedl_cls';	
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');			
		$data['sdata']['igedl_list'] 		= $this->icd_model->get_icd_igedl_details_list('','','','1','1','1','1','1','0');	
		
		// echo $this->db->last_query();return;
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*----------------- load icd_gate_entry_authorization_form page -----------------*/
	public function icd_gate_entry_authorization_form($igedl_id){		
		$data['sdata'] 			= array();
		$data['subview'] 		= 'icd/igeo/icd_gate_entry_authorization_form';		
		$data['active_cls'] 	= 'dash';			
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');					

		$data['sdata']['igedl_data'] 				= $this->icd_model->get_icd_igedl_details_list('',$igedl_id,'','1','1','1','1','1','0');
		$data['sdata']['iidl_list'] 				= $this->icd_model->get_icdl_iidl_details_list('',$igedl_id,'','1');
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}
 
	/*----------------- authorize_icd_gate_entry_details -----------------*/
	public function authorize_icd_gate_entry_details($igedl_id){
		$data['igedl_details'] = array();

		foreach($_POST as $post_key=>$post_rows){
			$data['igedl_details'][$post_key] 		= $this->input->post($post_key);			
		}		
		$data['igedl_details']['igedl_igeo_id'] 		= $this->user['i_user_id'];
		$data['igedl_details']['igedl_igeo_status'] 	= '1';
		$data['igedl_details']['igedl_igeo_date'] 		= date("Y-m-d");
		
		$edit_igedl 			= $this->admin_model->update_data('icd_gate_entry_details_list','igedl_id',$igedl_id,$data['igedl_details']);	
				
		if($edit_igedl!='0'){
			$this->session->set_flashdata('tos_success', 'Details updated');
			redirect('icd/icd_print_out_ctrl/authorize_icd_gate_entry_details_print_out/'.$igedl_id);
		}else {
			$this->session->set_flashdata('tos_warning', 'There is no changes!...');
			redirect('icd/igeo_ctrl/icd_gate_entry_authorization_list');
		}		
	}

	/*----------------- load icd_vehicle_out_gate_pass_list page -----------------*/
	public function icd_vehicle_out_gate_pass_list(){		
		$data['sdata'] 						= array();
		$data['subview'] 					= 'icd/igeo/icd_vehicle_out_gate_pass_list';		
		$data['active_cls'] 				= 'conedl_cls';	
		$data['url_list'] 					= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');			
		$data['sdata']['igedl_list'] 		= $this->icd_model->get_icd_igedl_details_list('','','','1','1','1','1','1','1','0');			
		// echo $this->db->last_query();return;
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*----------------- load icd_vehicle_out_gate_pass_form page -----------------*/
	public function icd_vehicle_out_gate_pass_form($igedl_id){		
		$data['sdata'] 			= array();
		$data['subview'] 		= 'icd/igeo/icd_vehicle_out_gate_pass_form';		
		$data['active_cls'] 	= 'dash';			
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');					

		$data['sdata']['igedl_data'] 				= $this->icd_model->get_icd_igedl_details_list('',$igedl_id,'','1','1','1','1','1','1','0');
		$data['sdata']['aginl_u_no'] 				= $this->admin_model->get_result_array('auto_generate_id_no_list','aginl_id','2');
		$data['sdata']['iidl_list'] 				= $this->icd_model->get_icdl_iidl_details_list('',$igedl_id,'','1');
		$this->load->view('icd/common/icd_sidepanel',$data); 
	} 

	/*----------------- authorize_icd_gate_entry_details -----------------*/
	public function update_icd_vehicle_out_gate_pass_details($igedl_id){
		$data['igedl_details'] = array();

		foreach($_POST as $post_key=>$post_rows){
			$data['igedl_details'][$post_key] 		= $this->input->post($post_key);			
		}		
		$data['igedl_details']['igedl_igeo_gate_out_pass_id'] 			= $this->user['i_user_id'];
		$data['igedl_details']['igedl_igeo_gate_out_pass_status'] 		= '1';
		$data['igedl_details']['igedl_igeo_gate_out_pass_date'] 		= date("Y-m-d");
		
		$edit_igedl 			= $this->admin_model->update_data('icd_gate_entry_details_list','igedl_id',$igedl_id,$data['igedl_details']);	

		$aginl_val 							=  $this->input->post('igedl_out_pass_no')+1;
		$data['aginl_details']['aginl_val'] = $aginl_val;
		$edit_aginl 						= $this->admin_model->update_data('auto_generate_id_no_list','aginl_id','2',$data['aginl_details']);
		
				
		if($edit_igedl!='0'){
			$this->session->set_flashdata('tos_success', 'Details updated');
			redirect('icd/igeo_ctrl/icd_vehicle_out_gate_pass_list');		
		}else {
			$this->session->set_flashdata('tos_warning', 'There is no changes!...');
			redirect('icd/igeo_ctrl/icd_vehicle_out_gate_pass_list');
		}		
	}

	/*----------------- load icd_container_out_local_gate_list page -----------------*/
	public function icd_container_out_local_gate_list(){		
		$data['sdata'] 			= array();
		$data['subview'] 		= 'icd/igeo/icd_container_out_local_gate_list';		
		$data['active_cls'] 	= 'conedl_cls';	
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');			
		if(isset($_POST['token_no_val'])){ 
			$token_no = $this->input->post('token_no_val');
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','',$token_no,'1','Local-Container&Material','1','1','1','1','1','1','1','0');
		}else if(!isset($_POST['token_no_val'])){		
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','','','1','Local-Container&Material','1','1','1','1','1','1','1','0');
		}
		// echo $this->db->last_query();return;
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}
 
	/*----------------- load icd_container_out_local_gate_form page -----------------*/
	public function icd_container_out_local_gate_form($igedl_id,$igetl_id){		
		$data['sdata'] 					= array();
		$data['subview'] 				= 'icd/igeo/icd_container_out_local_gate_form';		
		$data['active_cls'] 			= 'dash';			
		$data['url_list'] 				= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');					
		$data['sdata']['agl_list'] 		= $this->admin_model->get_result_array('agent_list');	
		$data['sdata']['igetl_data'] 		= $this->icd_model->get_icdl_igetl_details_list('',$igedl_id,$igetl_id,'','1','Local-Container&Material','1','1','1','1','1','1','1','0');	
			
		$data['sdata']['itncl_list'] 	= $this->icd_model->get_icdl_itncl_details_list('',$igetl_id,'','1','','1');
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*----------------- update_icd_container_out_local_gate_details -----------------*/
	public function update_icd_container_out_local_gate_details($igetl_id){		
		$data['igetl_details'] = array();

		foreach($_POST as $post_key=>$post_rows){
			$data['igetl_details'][$post_key] 		= $this->input->post($post_key);			
		}
		$data['igetl_details']['igetl_icolg_igeo_id'] 		= $this->user['i_user_id'];
		$data['igetl_details']['igetl_icolg_igeo_status'] 	= '1';
		$data['igetl_details']['igetl_icolg_igeo_date'] 		= date("Y-m-d");
		
		$edit_igetl 			= $this->admin_model->update_data('icd_gate_entry_token_list','igetl_id',$igetl_id,$data['igetl_details']);

		
				 
		if($edit_igetl!='0'){
			$this->session->set_flashdata('tos_success', 'Details updated');
			redirect('icd/icd_print_out_ctrl/icd_container_out_local_gate_print_out/'.$igetl_id);	
		}else {
			$this->session->set_flashdata('tos_warning', 'There is no changes!...');
			redirect('icd/igeo_ctrl/icd_container_out_local_gate_list');
		}			
				
	}

	/*---------------- load icd_gate_pass_out_entry_at_local_gate_list page ----------------*/
	public function icd_gate_pass_out_entry_at_local_gate_list(){		
		$data['sdata'] 			= array();
		$data['subview'] 		= 'icd/igeo/icd_gate_pass_out_entry_at_local_gate_list';		
		$data['active_cls'] 	= 'conedl_cls';	
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');			
		if(isset($_POST['token_no_val'])){ 
			$token_no = $this->input->post('token_no_val');
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','',$token_no,'1','Local-Container&Material','1','1','1','1','1','1','1','1','0');
		}else if(!isset($_POST['token_no_val'])){		
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','','','1','Local-Container&Material','1','1','1','1','1','1','1','1','0');
		}
		// echo $this->db->last_query();return;
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*---------------- load icd_gate_pass_out_entry_at_local_gate_form page ----------------*/
	public function icd_gate_pass_out_entry_at_local_gate_form($igedl_id,$igetl_id){		
		$data['sdata'] 					= array();
		$data['subview'] 				= 'icd/igeo/icd_gate_pass_out_entry_at_local_gate_form';		
		$data['active_cls'] 			= 'dash';			
		$data['url_list'] 				= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');				
		$data['sdata']['aginl_g_no'] 	= $this->admin_model->get_result_array('auto_generate_id_no_list','aginl_id','4');
			
		$data['sdata']['agl_list'] 		= $this->admin_model->get_result_array('agent_list');	
		$data['sdata']['igetl_data'] 		= $this->icd_model->get_icdl_igetl_details_list('',$igedl_id,$igetl_id,'','1','Local-Container&Material','1','1','1','1','1','1','1','1','0');	
		
		
		$data['sdata']['itncl_list'] 	= $this->icd_model->get_icdl_itncl_details_list('',$igetl_id,'','1','','1');
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*----------------- update_icd_gate_pass_out_entry_at_local_gate_details -----------------*/
	public function update_icd_gate_pass_out_entry_at_local_gate_details($igetl_id){		
		$data['igetl_details'] = array(); 

		foreach($_POST as $post_key=>$post_rows){
			$data['igetl_details'][$post_key] 		= $this->input->post($post_key);			
		}
		$data['igetl_details']['igetl_igpoelg_igeo_id'] 		= $this->user['i_user_id'];
		$data['igetl_details']['igetl_igpoelg_igeo_status'] 	= '1';
		$data['igetl_details']['igetl_igpoelg_igeo_date'] 		= date("Y-m-d");
		
		$edit_igetl 			= $this->admin_model->update_data('icd_gate_entry_token_list','igetl_id',$igetl_id,$data['igetl_details']);

		$aginl_val 							=  $this->input->post('igetl_gate_pass_out_no')+1;
		$data['aginl_details']['aginl_val'] = '00'.$aginl_val;
		$edit_aginl 						= $this->admin_model->update_data('auto_generate_id_no_list','aginl_id','4',$data['aginl_details']);
		
		
				
		if($edit_igetl!='0'){
			$this->session->set_flashdata('tos_success', 'Details updated');	
			redirect('icd/igeo_ctrl/icd_gate_pass_out_entry_at_local_gate_list');				
		}else {
			$this->session->set_flashdata('tos_warning', 'There is no changes!...');
			redirect('icd/igeo_ctrl/icd_gate_pass_out_entry_at_local_gate_list');
		}			
				
	}

	/*-----------load icd_vehicle_gpo_authorize_at_local_list page (gpo - gate pass out) -----------*/
	public function icd_vehicle_gpo_authorize_at_local_list(){		
		$data['sdata'] 			= array();
		$data['subview'] 		= 'icd/igeo/icd_vehicle_gpo_authorize_at_local_list';		
		$data['active_cls'] 	= 'conedl_cls';	
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');			
		if(isset($_POST['token_no_val'])){ 
			$token_no = $this->input->post('token_no_val');
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','',$token_no,'1','Local-Container&Material','1','1','1','1','1','1','1','1','1','1','0');
		}else if(!isset($_POST['token_no_val'])){		
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','','','1','Local-Container&Material','1','1','1','1','1','1','1','1','1','1','0');
		}
		// echo $this->db->last_query();return;
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*---------- load icd_vehicle_gpo_authorize_at_local_form page (gpo - gate pass out) ----------*/
	public function icd_vehicle_gpo_authorize_at_local_form($igedl_id,$igetl_id){		
		$data['sdata'] 					= array();
		$data['subview'] 				= 'icd/igeo/icd_vehicle_gpo_authorize_at_local_form';		
		$data['active_cls'] 			= 'dash';			
		$data['url_list'] 				= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');		
			
		$data['sdata']['agl_list'] 		= $this->admin_model->get_result_array('agent_list');	
		$data['sdata']['igetl_data'] 		= $this->icd_model->get_icdl_igetl_details_list('',$igedl_id,$igetl_id,'','1','Local-Container&Material','1','1','1','1','1','1','1','1','1','1','0');			
		$data['sdata']['itncl_list'] 	= $this->icd_model->get_icdl_itncl_details_list('',$igetl_id,'','1','','1');
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*---------- update_icd_vehicle_gpo_authorize_at_local (gpo - gate pass out) _details ----------*/
	public function update_icd_vehicle_gpo_authorize_at_local_details($igetl_id){		
		
		$data['igetl_details']['igetl_igpoal_igeo_id'] 		= $this->user['i_user_id'];
		$data['igetl_details']['igetl_igpoal_igeo_status'] 	= '1';
		$data['igetl_details']['igetl_igpoal_igeo_date'] 	= date("Y-m-d");
		
		$edit_igetl 			= $this->admin_model->update_data('icd_gate_entry_token_list','igetl_id',$igetl_id,$data['igetl_details']);
			
		if($edit_igetl!='0'){
			$this->session->set_flashdata('tos_success', 'Details updated');	
			redirect('icd/icd_print_out_ctrl/icd_vehicle_gpo_authorize_at_local_print_out/'.$igetl_id);				
		}else {
			$this->session->set_flashdata('tos_warning', 'There is no changes!...');
			redirect('icd/igeo_ctrl/icd_gate_pass_out_entry_at_local_gate_list');
		}			
				
	}

	/*-----------load icd_out_local_extra_icd_gate_list page  -----------*/
	public function icd_out_local_extra_icd_gate_list(){		
		$data['sdata'] 			= array();
		$data['subview'] 		= 'icd/igeo/icd_out_local_extra_icd_gate_list';		
		$data['active_cls'] 	= 'conedl_cls';	
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');	
		
		if(isset($_POST['token_no_val'])){ 
			$token_no = $this->input->post('token_no_val');
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','',$token_no,'1','Local-LCL/Extra Material','1','1','1','1','','','','','','','','1','1','1','0');
		}else if(!isset($_POST['token_no_val'])){		
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','','','1','Local-LCL/Extra Material','1','1','1','1','','','','','','','','1','1','1','0');
		}

		// echo $this->db->last_query();return;
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*---------- load icd_out_local_extra_icd_gate_form page  ----------*/
	public function icd_out_local_extra_icd_gate_form($igedl_id,$igetl_id){		
		$data['sdata'] 					= array();
		$data['subview'] 				= 'icd/igeo/icd_out_local_extra_icd_gate_form';		
		$data['active_cls'] 			= 'dash';			
		$data['url_list'] 				= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');		
			
		$data['sdata']['agl_list'] 		= $this->admin_model->get_result_array('agent_list');	
		$data['sdata']['igetl_data'] 		= $this->icd_model->get_icdl_igetl_details_list('',$igedl_id,$igetl_id,'','1','Local-LCL/Extra Material','1','1','1','1','','','','','','','','1','1','1','0');			
		// echo $this->db->last_query();return;
		
		$data['sdata']['itncl_list'] 	= $this->icd_model->get_icdl_itncl_details_list('',$igetl_id,'','1','','1');
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*---------- update update_icd_out_local_extra_icd_gate_details details ----------*/
	public function update_icd_out_local_extra_icd_gate_details($igetl_id){		
		foreach($_POST as $post_key=>$post_rows){
			$data['igetl_details'][$post_key] 		= $this->input->post($post_key);			
		}
			
		$data['igetl_details']['igetl_ioleig_igeo_id'] 		= $this->user['i_user_id'];
		$data['igetl_details']['igetl_ioleig_igeo_status'] 	= '1';
		$data['igetl_details']['igetl_ioleig_igeo_date'] 	= date("Y-m-d");
		
		$edit_igetl 			= $this->admin_model->update_data('icd_gate_entry_token_list','igetl_id',$igetl_id,$data['igetl_details']);
			
		if($edit_igetl!='0'){
			$this->session->set_flashdata('tos_success', 'Details updated');	
			redirect('icd/icd_print_out_ctrl/icd_out_local_extra_icd_gate_print_out/'.$igetl_id);
		}else {
			$this->session->set_flashdata('tos_warning', 'There is no changes!...');
			redirect('icd/igeo_ctrl/icd_out_local_extra_icd_gate_list');
		}			
				
	}

	/*-----------load icd_gate_pass_of_vehicle_out_loacl_extra_list page  -----------*/
	public function icd_gate_pass_of_vehicle_out_loacl_extra_list(){		
		$data['sdata'] 			= array();
		$data['subview'] 		= 'icd/igeo/icd_gate_pass_of_vehicle_out_loacl_extra_list';		
		$data['active_cls'] 	= 'conedl_cls';	
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');			
		if(isset($_POST['token_no_val'])){ 
			$token_no = $this->input->post('token_no_val');
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','',$token_no,'1','Local-LCL/Extra Material','1','1','1','1','','','','','','','','1','1','1','1','0');
		}else if(!isset($_POST['token_no_val'])){		
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','','','1','Local-LCL/Extra Material','1','1','1','1','','','','','','','','1','1','1','1','0');
		}
		// echo $this->db->last_query();return;
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*---------- load icd_gate_pass_of_vehicle_out_loacl_extra_form page  ----------*/
	public function icd_gate_pass_of_vehicle_out_loacl_extra_form($igedl_id,$igetl_id){		
		$data['sdata'] 					= array();
		$data['subview'] 				= 'icd/igeo/icd_gate_pass_of_vehicle_out_loacl_extra_form';		
		$data['active_cls'] 			= 'dash';			
		$data['url_list'] 				= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');		
			
		$data['sdata']['aginl_no'] 		= $this->admin_model->get_result_array('auto_generate_id_no_list','aginl_id','5');

		$data['sdata']['igetl_data'] 		= $this->icd_model->get_icdl_igetl_details_list('',$igedl_id,$igetl_id,'','1','Local-LCL/Extra Material','1','1','1','1','','','','','','','','1','1','1','1','0');			
		$data['sdata']['itncl_list'] 	= $this->icd_model->get_icdl_itncl_details_list('',$igetl_id,'','1','','1');

		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*----------------- update_icd_gate_pass_of_vehicle_out_loacl_extra_details -----------------*/
	public function update_icd_gate_pass_of_vehicle_out_loacl_extra_details($igetl_id){		
		$data['igetl_details'] = array(); 

		foreach($_POST as $post_key=>$post_rows){
			$data['igetl_details'][$post_key] 		= $this->input->post($post_key);			
		}
		$data['igetl_details']['igetl_igpvole_igeo_id'] 		= $this->user['i_user_id'];
		$data['igetl_details']['igetl_igpvole_igeo_status'] 	= '1';
		$data['igetl_details']['igetl_igpvole_igeo_date'] 		= date("Y-m-d");
		
		$edit_igedl 			= $this->admin_model->update_data('icd_gate_entry_token_list','igetl_id',$igetl_id,$data['igetl_details']);

		// echo $this->db->last_query();return;
		$aginl_val 							=  $this->input->post('igetl_gate_pass_no')+1;
		$data['aginl_details']['aginl_val'] =  $aginl_val;
		$edit_aginl 						=  $this->admin_model->update_data('auto_generate_id_no_list','aginl_id','5',$data['aginl_details']);
		
				
		if($edit_igedl!='0'){
			$this->session->set_flashdata('tos_success', 'Details updated');	
			redirect('icd/igeo_ctrl/icd_gate_pass_of_vehicle_out_loacl_extra_list');				
		}else {
			$this->session->set_flashdata('tos_warning', 'There is no changes!...');
			redirect('icd/igeo_ctrl/icd_gate_pass_of_vehicle_out_loacl_extra_list');
		}			
				
	}
 
	/*---------- update icd_out_authorize_transit_empty_list details ----------*/
	public function icd_out_authorize_transit_empty_list(){		
		$data['sdata'] 			= array();
		$data['subview'] 		= 'icd/igeo/icd_out_authorize_transit_empty_list';		
		$data['active_cls'] 	= 'conedl_cls';	
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');	
		if(isset($_POST['token_no_val'])){ 
			$token_no = $this->input->post('token_no_val');
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','',$token_no,'1','Local-Empty Container','1','1','1','1','','','','','','','','','','','','','','','1','0');
		}else if(!isset($_POST['token_no_val'])){		
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','','','1','Local-Empty Container','1','1','1','1','','','','','','','','','','','','','','','1','0');	
		}
		// echo $this->db->last_query();return;
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*---------- update icd_out_authorize_transit_empty_form details ----------*/
	public function icd_out_authorize_transit_empty_form($igetl_id){		
		$data['sdata'] 					= array();
		$data['subview'] 				= 'icd/igeo/icd_out_authorize_transit_empty_form';		
		$data['active_cls'] 			= 'dash';			
		$data['url_list'] 				= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');		
			
		$data['sdata']['igetl_data'] 		= $this->icd_model->get_icdl_igetl_details_list('','',$igetl_id,'','1','Local-Empty Container','1','1','1','1','','','','','','','','','','','','','','','1','0');			
		$data['sdata']['itncl_list'] 	= $this->icd_model->get_icdl_itncl_details_list('',$igetl_id,'','1','','1');
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*---------- update update_icd_out_authorize_transit_empty_details details ----------*/
	public function update_icd_out_authorize_transit_empty_details($igetl_id){		
		
		$data['igetl']['igetl_iovgete_igeo_id'] 		= $this->user['i_user_id'];
		$data['igetl']['igetl_iovgete_igeo_status'] 	= '1';
		$data['igetl']['igetl_iovgete_igeo_date'] 		= date("Y-m-d");
		
		$edit_igetl 			= $this->admin_model->update_data('icd_gate_entry_token_list','igetl_id',$igetl_id,$data['igetl']);
				
		if($edit_igetl!='0'){
			$this->session->set_flashdata('tos_success', 'Details updated');	
			redirect('icd/igeo_ctrl/icd_out_authorize_transit_empty_list');					
		}else {
			$this->session->set_flashdata('tos_warning', 'There is no changes!...');
			redirect('icd/igeo_ctrl/icd_out_authorize_transit_empty_list');
		}			
				
	}

	/*---------- update icd_gate_pass_out_icd_gate_transit_empty_list details ----------*/
	public function icd_gate_pass_out_icd_gate_transit_empty_list(){		
		$data['sdata'] 			= array();
		$data['subview'] 		= 'icd/igeo/icd_gate_pass_out_icd_gate_transit_empty_list';		
		$data['active_cls'] 	= 'conedl_cls';	
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');			
		if(isset($_POST['token_no_val'])){ 
			$token_no = $this->input->post('token_no_val');
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','',$token_no,'1','Local-Empty Container','1','1','1','1','','','','','','','','','','','','','','','1','1','1','1','0');
		}else if(!isset($_POST['token_no_val'])){		
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','','','1','Local-Empty Container','1','1','1','1','','','','','','','','','','','','','','','1','1','1','1','0');
		}
		// echo $this->db->last_query();return;
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*---------- load icd_gate_pass_out_icd_gate_transit_empty_form  page  ----------*/
	public function icd_gate_pass_out_icd_gate_transit_empty_form($igetl_id){		
		$data['sdata'] 					= array();
		$data['subview'] 				= 'icd/igeo/icd_gate_pass_out_icd_gate_transit_empty_form';		
		$data['active_cls'] 			= 'dash';			
		$data['url_list'] 				= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');		
		
		$data['sdata']['aginl_no'] 		= $this->admin_model->get_result_array('auto_generate_id_no_list','aginl_id','4');
		
		$data['sdata']['igetl_data'] 		= $this->icd_model->get_icdl_igetl_details_list('','',$igetl_id,'','1','Local-Empty Container','1','1','1','1','','','','','','','','','','','','','','','1','1','1','1','0');			
		$data['sdata']['itncl_list'] 	= $this->icd_model->get_icdl_itncl_details_list('',$igetl_id,'','1','','1');
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*---------- update update_icd_gate_pass_out_icd_gate_transit_empty_details details ----------*/
	public function update_icd_gate_pass_out_icd_gate_transit_empty_details($igetl_id){	
		$aginl_no 			= $this->admin_model->get_result_array('auto_generate_id_no_list','aginl_id','4');	
		$data['igetl'] = array();

		foreach($_POST as $post_key=>$post_rows){
			$data['igedl_details'][$post_key] 		= $this->input->post($post_key);			
		}

		$data['igetl']['igetl_transit_gate_pass_out_no'] 		= 'ICD-GPO-'.$aginl_no['aginl_val'];
		
		$data['igetl']['igetl_gpote_igeo_id'] 					= $this->user['i_user_id'];
		$data['igetl']['igetl_gpote_igeo_status'] 				= '1';
		$data['igetl']['igetl_gpote_igeo_date'] 				= date("Y-m-d");
		
		$edit_igetl 			= $this->admin_model->update_data('icd_gate_entry_token_list','igetl_id',$igetl_id,$data['igetl']);


		$aginl_val 							=  $aginl_no['aginl_val']+1;
		$data['aginl_details']['aginl_val'] = '00'.$aginl_val;
		$edit_aginl 						= $this->admin_model->update_data('auto_generate_id_no_list','aginl_id','4',$data['aginl_details']);
		// echo $this->db->last_query();
		// var_dump($aginl_val);return;
		
				
		if($edit_igetl!='0'){
			$this->session->set_flashdata('tos_success', 'Details updated');	
			redirect('icd/igeo_ctrl/icd_gate_pass_out_icd_gate_transit_empty_list');
		}else {
			$this->session->set_flashdata('tos_warning', 'There is no changes!...');
			redirect('icd/igeo_ctrl/icd_gate_pass_out_icd_gate_transit_empty_list');
		}			
				
	}


	/*---------- update icd_gate_vehicle_pass_out_transit_empty_list details ----------*/
	public function icd_gate_vehicle_pass_out_transit_empty_list(){		
		$data['sdata'] 			= array();
		$data['subview'] 		= 'icd/igeo/icd_gate_vehicle_pass_out_transit_empty_list';		
		$data['active_cls'] 	= 'conedl_cls';	
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');			
		if(isset($_POST['token_no_val'])){ 
			$token_no = $this->input->post('token_no_val');
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','',$token_no,'1','Local-Empty Container','1','1','1','1','','','','','','','','','','','','','','','1','1','1','1','1','1','0');
		}else if(!isset($_POST['token_no_val'])){		
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','','','1','Local-Empty Container','1','1','1','1','','','','','','','','','','','','','','','1','1','1','1','1','1','0');
		}
		// echo $this->db->last_query();return;
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*---------- load icd_gate_vehicle_pass_out_transit_empty_form  page  ----------*/
	public function icd_gate_vehicle_pass_out_transit_empty_form($igetl_id){		
		$data['sdata'] 					= array();
		$data['subview'] 				= 'icd/igeo/icd_gate_vehicle_pass_out_transit_empty_form';		
		$data['active_cls'] 			= 'dash';			
		$data['url_list'] 				= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');		
				
		$data['sdata']['igetl_data'] 		= $this->icd_model->get_icdl_igetl_details_list('','',$igetl_id,'','1','Local-Empty Container','1','1','1','1','','','','','','','','','','','','','','','1','1','1','1','1','1','0');			
		$data['sdata']['itncl_list'] 	= $this->icd_model->get_icdl_itncl_details_list('',$igetl_id,'','1','','1');
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}


	/*---------- update update_icd_gate_vehicle_pass_out_transit_empty_details details ----------*/
	public function update_icd_gate_vehicle_pass_out_transit_empty_details($igetl_id){		
		// $data['igetl'] = array();

		// foreach($_POST as $post_key=>$post_rows){
		// 	$data['igetl'][$post_key] 		= $this->input->post($post_key);			
		// }

		$data['igetl']['igetl_igvpote_igeo_id'] 		= $this->user['i_user_id'];
		$data['igetl']['igetl_igvpote_igeo_status'] 	= '1';
		$data['igetl']['igetl_igvpote_igeo_date'] 	= date("Y-m-d");
		
		$edit_igetl 			= $this->admin_model->update_data('icd_gate_entry_token_list','igetl_id',$igetl_id,$data['igetl']);
		 
		if($edit_igetl!='0'){
			$this->session->set_flashdata('tos_success', 'Details updated');	
			redirect('icd/icd_print_out_ctrl/icd_gate_vehicle_pass_out_transit_empty_print_out/'.$igetl_id);
		}else {
			$this->session->set_flashdata('tos_warning', 'There is no changes!...');
			redirect('icd/igeo_ctrl/icd_gate_vehicle_pass_out_transit_empty_list');
		}			
				
	}

	/*---------- update icd_out_transit_material_icd_gate_list details ----------*/
	public function icd_out_transit_material_icd_gate_list(){		
		$data['sdata'] 			= array();
		$data['subview'] 		= 'icd/igeo/icd_out_transit_material_icd_gate_list';		
		$data['active_cls'] 	= 'conedl_cls';	
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');			
		if(isset($_POST['token_no_val'])){ 
			$token_no = $this->input->post('token_no_val');
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','',$token_no,'2','Transit-Material','1','1','1','1','','','','','','','','','','','','','','','','','','','','','','1','1','1','0');
		}else if(!isset($_POST['token_no_val'])){		
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','','','2','Transit-Material','1','1','1','1','','','','','','','','','','','','','','','','','','','','','','1','1','1','0');
		}
		// echo $this->db->last_query();return;
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}
	
	/*---------- load icd_out_transit_material_icd_gate_form  page  ----------*/
	public function icd_out_transit_material_icd_gate_form($igetl_id){		
		$data['sdata'] 					= array();
		$data['subview'] 				= 'icd/igeo/icd_out_transit_material_icd_gate_form';		
		$data['active_cls'] 			= 'dash';			
		$data['url_list'] 				= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');	
		
		$data['sdata']['igetl_data'] 		= $this->icd_model->get_icdl_igetl_details_list('','',$igetl_id,'','2','Transit-Material','1','1','1','1','','','','','','','','','','','','','','','','','','','','','','1','1','1','0');
		$data['sdata']['itml_list'] 	= $this->icd_model->get_icdl_itml_details_list('',$igetl_id,'','1');
		
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*---------- update update_icd_out_transit_material_icd_gate_details details ----------*/
	public function update_icd_out_transit_material_icd_gate_details($igetl_id){		
		$data['igetl'] = array();

		foreach($_POST as $post_key=>$post_rows){
			$data['igetl'][$post_key] 		= $this->input->post($post_key);			
		}

		$data['igetl']['igetl_otm_igeo_id'] 		= $this->user['i_user_id'];
		$data['igetl']['igetl_otm_igeo_status'] 	= '1';
		$data['igetl']['igetl_otm_igeo_date'] 		= date("Y-m-d");
		
		$edit_igetl 			= $this->admin_model->update_data('icd_gate_entry_token_list','igetl_id',$igetl_id,$data['igetl']);
				
		if($edit_igetl!='0'){
			$this->session->set_flashdata('tos_success', 'Details updated');	
			redirect('icd/icd_print_out_ctrl/icd_out_transit_material_icd_gate_print_out/'.$igetl_id);
		}else {
			$this->session->set_flashdata('tos_warning', 'There is no changes!...');
			redirect('icd/igeo_ctrl/icd_out_transit_material_icd_gate_list');
		}			
				
	}

	/*---------- update icd_transit_material_icd_gate_list details ----------*/
	public function icd_transit_material_icd_gate_list(){		
		$data['sdata'] 			= array();
		$data['subview'] 		= 'icd/igeo/icd_transit_material_icd_gate_list';		
		$data['active_cls'] 	= 'conedl_cls';	
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');			
		if(isset($_POST['token_no_val'])){ 
			$token_no = $this->input->post('token_no_val');
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','',$token_no,'2','Transit-Material','1','1','1','1','','','','','','','','','','','','','','','','','','','','','','1','1','1','1','0');
		}else if(!isset($_POST['token_no_val'])){		
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','','','2','Transit-Material','1','1','1','1','','','','','','','','','','','','','','','','','','','','','','1','1','1','1','0');
		}
		// echo $this->db->last_query();return;
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*---------- load icd_transit_material_icd_gate_form  page  ----------*/
	public function icd_transit_material_icd_gate_form($igetl_id){		
		$data['sdata'] 					= array();
		$data['subview'] 				= 'icd/igeo/icd_transit_material_icd_gate_form';		
		$data['active_cls'] 			= 'dash';			
		$data['url_list'] 				= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');	
		
		$data['sdata']['igetl_data'] 		= $this->icd_model->get_icdl_igetl_details_list('','',$igetl_id,'','2','Transit-Material','1','1','1','1','','','','','','','','','','','','','','','','','','','','','','1','1','1','1','0');
		$data['sdata']['itml_list'] 	= $this->icd_model->get_icdl_itml_details_list('',$igetl_id,'','1');
		$data['sdata']['aginl_u_no'] 		= $this->admin_model->get_result_array('auto_generate_id_no_list','aginl_id','4');
		 
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*---------- update update_icd_transit_material_icd_gate_details details ----------*/
	public function update_icd_transit_material_icd_gate_details($igetl_id){
		$aginl_no 			= $this->admin_model->get_result_array('auto_generate_id_no_list','aginl_id','4');	
		$data['igetl'] = array();

		foreach($_POST as $post_key=>$post_rows){
			$data['igetl'][$post_key] 		= $this->input->post($post_key);			
		}

		$data['igetl']['igetl_otm_gate_pass_out_no'] 		= 'ICD-GPO-'.$aginl_no['aginl_val'];		
		$data['igetl']['igetl_tm_igeo_id'] 					= $this->user['i_user_id'];
		$data['igetl']['igetl_tm_igeo_status'] 				= '1';
		$data['igetl']['igetl_tm_igeo_date'] 				= date("Y-m-d");
		
		$edit_igetl 										= $this->admin_model->update_data('icd_gate_entry_token_list','igetl_id',$igetl_id,$data['igetl']);
				
		$aginl_val 											=  $aginl_no['aginl_val']+1;
		$data['aginl_details']['aginl_val'] 				= '00'.$aginl_val;
		$edit_aginl 										= $this->admin_model->update_data('auto_generate_id_no_list','aginl_id','4',$data['aginl_details']);
		

		if($edit_igetl!='0'){
			$this->session->set_flashdata('tos_success', 'Details updated');	
			redirect('icd/igeo_ctrl/icd_transit_material_icd_gate_list');
		}else {
			$this->session->set_flashdata('tos_warning', 'There is no changes!...');
			redirect('icd/igeo_ctrl/icd_transit_material_icd_gate_list');
		}			
				
	}


	/*---------- update icd_out_transit_material_icd_gate_print_list details ----------*/
	public function icd_out_transit_material_icd_gate_print_list(){		
		$data['sdata'] 			= array();
		$data['subview'] 		= 'icd/igeo/icd_out_transit_material_icd_gate_print_list';		
		$data['active_cls'] 	= 'conedl_cls';	
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');			
		if(isset($_POST['token_no_val'])){ 
			$token_no = $this->input->post('token_no_val');
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','',$token_no,'2','Transit-Material','1','1','1','1','','','','','','','','','','','','','','','','','','','','','','1','1','1','1','1','1','0');
		}else if(!isset($_POST['token_no_val'])){		
			$data['sdata']['igetl_list'] 		= $this->icd_model->get_icdl_igetl_details_list('','','','','2','Transit-Material','1','1','1','1','','','','','','','','','','','','','','','','','','','','','','1','1','1','1','1','1','0');
		}
		// echo $this->db->last_query();return;
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*---------- load icd_out_transit_material_icd_gate_print_form  page  ----------*/
	public function icd_out_transit_material_icd_gate_print_form($igetl_id){		
		$data['sdata'] 					= array();
		$data['subview'] 				= 'icd/igeo/icd_out_transit_material_icd_gate_print_form';		
		$data['active_cls'] 			= 'dash';			
		$data['url_list'] 				= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');	
		
		$data['sdata']['igetl_data'] 		= $this->icd_model->get_icdl_igetl_details_list('','',$igetl_id,'','2','Transit-Material','1','1','1','1','','','','','','','','','','','','','','','','','','','','','','1','1','1','1','1','1','0');
		$data['sdata']['itml_list'] 	= $this->icd_model->get_icdl_itml_details_list('',$igetl_id,'','1');
		
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*---------- update update_icd_out_transit_material_icd_gate_print_details details ----------*/
	public function update_icd_out_transit_material_icd_gate_print_details($igetl_id){		
		
		$data['igetl']['igetl_tm_print_igeo_id'] 		= $this->user['i_user_id'];
		$data['igetl']['igetl_tm_print_igeo_status'] 	= '1';
		$data['igetl']['igetl_tm_print_igeo_date'] 		= date("Y-m-d");
		
		$edit_igetl 			= $this->admin_model->update_data('icd_gate_entry_token_list','igetl_id',$igetl_id,$data['igetl']);
				
		
		if($edit_igetl!='0'){
			$this->session->set_flashdata('tos_success', 'Details updated');	
			redirect('icd/icd_print_out_ctrl/icd_out_transit_material_icd_gate_print_print_out/'.$igetl_id);
		}else {
			$this->session->set_flashdata('tos_warning', 'There is no changes!...');
			redirect('icd/geo_ctrl/icd_out_transit_material_icd_gate_print_list');
		}			
				
	}



	
}
