<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Mceo_ctrl extends user_icd_index {
 
	
	public function __construct(){
		parent::__construct(); 
		$data = array();
		$this->load->model('admin_model');
	}  
	
	/*----------------- load register page -----------------*/
	public function mceo_register(){		
		$data['sdata'] 			= array();
		$data['subview'] 		= 'icd/mceo/mceo_register';	 	
		$data['active_cls'] 	= 'dash';		
		$last = $this->db->order_by('idl_id',"desc")->limit(1)->get('icd_details_list')->row(); 
		// var_dump($last->idl_id);return;
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');
		$data['pal_list'] 		= $this->admin_model->get_result_array('payment_agency_list');
		$data['ctl_list'] 		= $this->admin_model->get_result_array('cargo_type_list');
		$data['csl_list'] 		= $this->admin_model->get_result_array('container_status_list');
		// $data['idl_count'] 		= $this->admin_model->get_counts('icd_details_list');
		if($last==''){
			$data['idl_count'] 		= '0';			
		}else if($last->idl_id!=''){
			$data['idl_count'] 		= $last->idl_id;
		}
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	
	/*----------------- add icd register  details -----------------*/
	public function insert_icd_regi_details(){		
		$this->form_validation->set_rules('idl_vessel_name', 'Vessel Name', 'trim|required');
		$this->form_validation->set_rules('idl_csl_id', 'Container Status', 'trim|required');
		$this->form_validation->set_rules('idl_bill_of_loading', 'Bill Of Loading', 'trim|required');
		$this->form_validation->set_rules('idl_ctl_id', 'Type Of Cargo', 'trim|required');
		$this->form_validation->set_rules('idl_shipping_line', 'Shipping Line', 'trim|required');
		$this->form_validation->set_rules('idl_pal_id', 'Payment Agency', 'trim|required');
		$this->form_validation->set_rules('idl_ref_no', 'Ref No', 'trim|required');
		$this->form_validation->set_rules('idl_date', 'Date', 'trim|required');

		
		if ($this->form_validation->run() === FALSE) {
			$e_msg = ''; 			
			$e_msg .= form_error('idl_vessel_name');   			
			$e_msg .= form_error('idl_csl_id'); 
			$e_msg .= form_error('idl_bill_of_loading');   		
			$e_msg .= form_error('idl_ctl_id');   
			$e_msg .= form_error('idl_shipping_line');   			
			$e_msg .= form_error('idl_pal_id');   
			$e_msg .= form_error('idl_ref_no');   		
			$e_msg .= form_error('idl_date'); 
			$this->session->set_flashdata('tos_error', $e_msg);
			redirect('icd/mceo_ctrl/mceo_register');	return;			
			
		}	
		$data['idl_details'] = array();
		foreach($_POST as $post_key=>$post_rows){
			if($post_key!='icdl_c_no' && $post_key!='icdl_c_size' && $post_key!='icdl_c_type' && $post_key!='icdl_goods_desc' && $post_key!='icdl_c_status' && $post_key!='icdl_c_seal_s_no1' && $post_key!='icdl_c_seal_s_no2'){
				$data['idl_details'][$post_key] 		= $this->input->post($post_key);
			}
		}
		$data['idl_details']['idl_mceo_id'] 			= $this->user['i_user_id'];
		$data['idl_details']['idl_mceo_status'] 		= '1';
		$data['idl_details']['idl_mceo_date'] 			= date("Y-m-d");
		
		$add_idl 			= $this->admin_model->insert_item('icd_details_list',$data['idl_details']);

		$icdl_c_no 			= $this->input->post('icdl_c_no');
		$icdl_c_size 		= $this->input->post('icdl_c_size');
		$icdl_c_type 		= $this->input->post('icdl_c_type');
		$icdl_goods_desc 	= $this->input->post('icdl_goods_desc');
		// $icdl_c_status 		= $this->input->post('icdl_c_status');
		$icdl_c_seal_s_no1 	= $this->input->post('icdl_c_seal_s_no1');
		$icdl_c_seal_s_no2 	= $this->input->post('icdl_c_seal_s_no2');
		
		$icdl_count_val = 0;
		foreach($icdl_c_no as $icdl_key=>$icdl_row){
			$data['icdl_details']['icdl_idl_id'] 		=  $add_idl;				
			$data['icdl_details']['icdl_c_no'] 			=  $icdl_row;
			$data['icdl_details']['icdl_c_size'] 		=  $icdl_c_size[$icdl_key];
			$data['icdl_details']['icdl_c_type'] 		=  $icdl_c_type[$icdl_key];
			$data['icdl_details']['icdl_goods_desc'] 	=  $icdl_goods_desc[$icdl_key];
			// $data['icdl_details']['icdl_c_status'] 		=  $icdl_c_status[$icdl_key];
			$data['icdl_details']['icdl_c_seal_s_no1'] 	=  $icdl_c_seal_s_no1[$icdl_key];
			$data['icdl_details']['icdl_c_seal_s_no2'] 	=  $icdl_c_seal_s_no2[$icdl_key];	
			$add_icdl 									= $this->admin_model->insert_item('icd_container_details_list',$data['icdl_details']);	
			$icdl_count_val = $icdl_count_val+1;
		}

		$data['idl_details_u']['idl_remaining_conatiner'] 	= $icdl_count_val;
		$data['idl_details_u']['idl_total_container'] 		= $icdl_count_val;
		
		$edit_idl 			= $this->admin_model->update_data('icd_details_list','idl_id',$add_idl,$data['idl_details_u']);

				
		if($add_idl!='0'){
			$this->session->set_flashdata('tos_success', 'Register details added');
			redirect('icd/mceo_ctrl/mceo_register');
		}else {
			$this->session->set_flashdata('tos_warning', 'There is no changes!...');
			redirect('icd/mceo_ctrl/mceo_register');
		}			
				
	}
	
	
	
}
