<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Tno_ctrl extends user_icd_index {
 
	
	public function __construct(){
		parent::__construct(); 
		$data = array();
		$this->load->model('admin_model');
		$this->load->model('icd_model');		
	}
	 
	/*----------------- load truck_nomination_list page -----------------*/
	public function truck_nomination_list(){		
		$data['sdata'] 			= array();
		$data['subview'] 		= 'icd/tno/truck_nomination_list';		
		$data['active_cls'] 	= 'conedl_cls';	
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');		
		$data['sdata']['idl_list'] 		= $this->icd_model->get_icd_details_list('','1','1','1','1','','0');	
		// echo $this->db->last_query();return;			
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*----------------- load truck_nomination_details page -----------------*/
	public function truck_nomination_details($idl_id){		 
		$data['sdata'] 					= array();
		$data['subview'] 				= 'icd/tno/truck_nomination_details';		
		$data['active_cls'] 			= 'dash';			
		$data['url_list'] 				= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');			
	
		$data['sdata']['idl_data'] 		= $this->icd_model->get_icd_details_list($idl_id,'1','1','1','1','','0');
		$data['sdata']['icdl_list'] 	= $this->icd_model->get_icdl_details_list($idl_id,'','0');
		$data['sdata']['tl_list'] 	= $this->admin_model->get_result_array_with_one_where('transporter_list','tl_type','icd');	
		$this->load->view('icd/common/icd_sidepanel',$data);  
	}

	/*----------------- update update_truck_nominationy_details  -----------------*/
	public function update_truck_nominationy_details($idl_id){		
		$this->form_validation->set_rules('igedl_initiated_by', 'Initiated By ', 'trim|required');

		
		if ($this->form_validation->run() === FALSE) {
			$e_msg = ''; 			  	
			$e_msg .= form_error('igedl_initiated_by');   	
			$this->session->set_flashdata('tos_error', $e_msg);
			redirect('icd/tno_ctrl/truck_nomination_list');	return;			
			
		}			
		$data['igedl_details']['igedl_idl_id'] 			= $idl_id;
		$data['igedl_details']['igedl_initiated_by'] 	= $this->input->post('igedl_initiated_by');
		$data['igedl_details']['igedl_tno_id'] 			= $this->user['i_user_id'];		
		$data['igedl_details']['igedl_tno_status'] 		= '1';		
		$data['igedl_details']['igedl_tno_date'] 		= date('Y-m-d');	
		
		$data['igedl_details']['igedl_tno_iomo_id'] 	= $this->user['i_user_id'];
		$data['igedl_details']['igedl_tno_iomo_status'] = '1';
		$data['igedl_details']['igedl_tno_iomo_date'] 	= date("Y-m-d");
		$add_igedl 										= $this->admin_model->insert_item('icd_gate_entry_details_list',$data['igedl_details']);


		$icdl_id 			= $this->input->post('icdl_id');
		$icdl_truck_no 		= $this->input->post('icdl_truck_no');
		$icdl_trailer_no 	= $this->input->post('icdl_trailer_no');
		$icdl_driver_name 	= $this->input->post('icdl_driver_name');
		$icdl_license 		= $this->input->post('icdl_license');
		$icdl_transporter 	= $this->input->post('icdl_transporter');
		
		$idl_remaining_conatiner 	= $this->input->post('idl_remaining_conatiner');
		$idl_remaining_conatiner_c 	= 0;

		foreach($icdl_id as $icdl_key=>$icdl_row){		
			if($icdl_row!='0'){		
				$data['icdl_details']['icdl_id'] 			=  $icdl_row;
				$data['icdl_details']['icdl_truck_no'] 		=  $icdl_truck_no[$icdl_key];
				$data['icdl_details']['icdl_trailer_no'] 	=  $icdl_trailer_no[$icdl_key];
				$data['icdl_details']['icdl_driver_name'] 	=  $icdl_driver_name[$icdl_key];
				$data['icdl_details']['icdl_license'] 		=  $icdl_license[$icdl_key];
				$data['icdl_details']['icdl_transporter'] 	=  $icdl_transporter[$icdl_key];
				$data['icdl_details']['icdl_tno_status'] 	=  '1';
				$edit_icdl 									= $this->admin_model->update_data('icd_container_details_list','icdl_id',$icdl_row,$data['icdl_details']);	

				$data['iidl_details']['iidl_igedl_id'] 			=  $add_igedl;
				$data['iidl_details']['iidl_icdl_id'] 			=  $icdl_row;
				
				$add_iidl									= $this->admin_model->insert_item('igedl_icdl_details_list',$data['iidl_details']);

				$idl_remaining_conatiner_c = $idl_remaining_conatiner_c+1;
			}
		}
		$idl_remaining_conatiner_val 					= $idl_remaining_conatiner-$idl_remaining_conatiner_c;
		$data['idl_details']['idl_remaining_conatiner'] = $idl_remaining_conatiner_val;
		if($idl_remaining_conatiner_val=='0'){		
			$data['idl_details']['idl_tno_completed_status'] 		= '1';		
		}	

		$edit_idl 			= $this->admin_model->update_data('icd_details_list','idl_id',$idl_id,$data['idl_details']);
		

		

		if($add_igedl!='0'){
			$this->session->set_flashdata('tos_success', 'Details updated');
			redirect('icd/tno_ctrl/truck_nomination_list');
		}else {
			$this->session->set_flashdata('tos_warning', 'There is no changes!...');
			redirect('icd/tno_ctrl/truck_nomination_list');
		}			
				
	}

	/*----------------- load truck_nomination_approvel_list page -----------------*/
	public function truck_nomination_approvel_list(){		
		$data['sdata'] 			= array();
		$data['subview'] 		= 'icd/tno/truck_nomination_approvel_list';		
		$data['active_cls'] 	= 'dash';	
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');			
		$data['sdata']['igedl_list'] 		= $this->icd_model->get_icd_igedl_details_list('','','','1','0');
		// echo $this->db->last_query();return;
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	 
	/*----------------- load truck_nomination_approvel_details page -----------------*/
	public function truck_nomination_approvel_details($igedl_id){		
		$data['sdata'] 			= array();
		$data['subview'] 		= 'icd/tno/truck_nomination_approvel_details';		
		$data['active_cls'] 	= 'dash';			
		$data['url_list'] 		= $this->admin_model->get_result_array_with_one_where('user_role_list','url_status','1');			

		$data['sdata']['igedl_data'] 				= $this->icd_model->get_icd_igedl_details_list('',$igedl_id,'','1','0');
		// echo $this->db->last_query();return;
		
		$data['sdata']['iidl_list'] 				= $this->icd_model->get_icdl_iidl_details_list('',$igedl_id,'','1');
		
		
		$this->load->view('icd/common/icd_sidepanel',$data); 
	}

	/*----------------- authorize_gate1_entry_details -----------------*/
	public function update_truck_nomination_approvel_details($igedl_id){		
		$data['igedl_details']['igedl_tno_iomo_id'] 		= $this->user['i_user_id'];
		$data['igedl_details']['igedl_tno_iomo_status'] 	= '1';
		$data['igedl_details']['igedl_tno_iomo_date'] 	= date("Y-m-d");
		
		$edit_igedl 			= $this->admin_model->update_data('icd_gate_entry_details_list','igedl_id',$igedl_id,$data['igedl_details']);	
				
		if($edit_igedl!='0'){
			$this->session->set_flashdata('tos_success', 'Details updated');
			redirect('icd/tno_ctrl/truck_nomination_approvel_list');		
		}else {
			$this->session->set_flashdata('tos_warning', 'There is no changes!...');
			redirect('icd/tno_ctrl/truck_nomination_approvel_list');
		}		
	}
	
}
